/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.pipelessPipes.Network;

import de.tim2byte.pipelessPipes.Network.PipeNetwork;
import de.tim2byte.pipelessPipes.PipelessPipes;
import de.tim2byte.pipelessPipes.Util.Configs;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.scheduler.BukkitRunnable;

public class PipeSystemWorker
extends BukkitRunnable {
    private static PipeSystemWorker instance;
    private final Map<UUID, PipeNetwork> activeNetworks = new ConcurrentHashMap<UUID, PipeNetwork>();

    public PipeSystemWorker() {
        instance = this;
        PipelessPipes.getLog().info("Starting PipeSystemWorker and loading networks...");
        this.loadAllNetworks();
    }

    public void run() {
        if (this.activeNetworks.isEmpty()) {
            return;
        }
        this.activeNetworks.values().forEach(PipeNetwork::distributeItems);
    }

    public void loadAllNetworks() {
        this.activeNetworks.clear();
        ConfigurationSection networksSection = Configs.PIPE_DATA.getConfigurationSection("networks");
        if (networksSection == null) {
            PipelessPipes.getLog().info("No pipe networks found to load.");
            return;
        }
        for (String networkIdStr : networksSection.getKeys(false)) {
            PipeNetwork network = PipeNetwork.load(networkIdStr);
            if (network != null) {
                this.activeNetworks.put(network.getNetworkID(), network);
                continue;
            }
            PipelessPipes.getLog().warning("Failed to load pipe network with ID: " + networkIdStr);
        }
        PipelessPipes.getLog().info("Successfully loaded " + this.activeNetworks.size() + " pipe networks.");
    }

    public void reloadNetwork(UUID networkId) {
        PipelessPipes.getLog().finer("Reloading network: " + String.valueOf(networkId));
        PipeNetwork reloadedNetwork = PipeNetwork.load(networkId.toString());
        if (reloadedNetwork != null) {
            this.activeNetworks.put(networkId, reloadedNetwork);
            PipelessPipes.getLog().info("Successfully reloaded network: " + String.valueOf(networkId));
        } else {
            this.activeNetworks.remove(networkId);
            PipelessPipes.getLog().warning("Failed to reload network " + String.valueOf(networkId) + ". It might have been removed.");
        }
    }

    @Generated
    public static PipeSystemWorker getInstance() {
        return instance;
    }
}

