/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.pipelessPipes.Network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tim2byte.pipelessPipes.GUIs.PipeGUI;
import de.tim2byte.pipelessPipes.Network.PipeSystemWorker;
import de.tim2byte.pipelessPipes.Network.PipeWrenchManager;
import de.tim2byte.pipelessPipes.PipelessPipes;
import de.tim2byte.pipelessPipes.Util.Configs;
import io.papermc.paper.block.TileStateInventoryHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeNetwork {
    private final UUID networkID;
    private final UUID ownerUUID;
    private final ArrayList<PipeNode> inputNodes;
    private final ArrayList<PipeNode> outputNodes;

    @NotNull
    public static UUID getFreeNetID() {
        UUID newNetworkID;
        while (Configs.PIPE_DATA.contains("networks." + String.valueOf(newNetworkID = UUID.randomUUID()) + ".ownerUUID")) {
        }
        return newNetworkID;
    }

    @NotNull
    public UUID getFreeNodeID() {
        return UUID.randomUUID();
    }

    public void addNode(PipeNode node, TileStateInventoryHolder holder, @Nullable Player player) {
        if (node.isInputNode) {
            this.getInputNodes().add(node);
        } else {
            this.getOutputNodes().add(node);
        }
        this.save();
        holder.getPersistentDataContainer().set(PipeWrenchManager.PIPE_DATA_KEY, PersistentDataType.STRING, (Object)node.toString());
        holder.update(true, false);
        PipelessPipes.getLog().info("Added new Node %s to PipeNetwork %s".formatted(node.toString(), this.getNetworkID()));
        if (player != null) {
            player.closeInventory();
            player.openInventory(new PipeGUI(player, this, node, holder, node.isInputNode ? "open_input_node" : "open_output_node").getInventory());
        }
    }

    public void removeNode(PipeNode node, TileStateInventoryHolder holder) {
        if (node.isInputNode) {
            this.getInputNodes().remove(node);
        } else {
            this.getOutputNodes().remove(node);
        }
        this.save();
        holder.getPersistentDataContainer().remove(PipeWrenchManager.PIPE_DATA_KEY);
        holder.update(true, false);
        PipelessPipes.getLog().info("Removed Node %s from PipeNetwork %s".formatted(node.toString(), this.getNetworkID()));
    }

    public void distributeItems() {
        if (this.outputNodes.isEmpty() || this.inputNodes.isEmpty()) {
            return;
        }
        ArrayList<PipeNode> shuffledOutputs = new ArrayList<PipeNode>(this.outputNodes);
        for (PipeNode inputNode : this.inputNodes) {
            Inventory inputInventory = inputNode.holder().getInventory();
            ItemStack[] contents = inputInventory.getStorageContents();
            for (int i = 0; i < contents.length; ++i) {
                List<Inventory> validOutputInventories;
                ItemStack itemStack = contents[i];
                if (itemStack == null || itemStack.getType() == Material.AIR || (validOutputInventories = this.findValidOutputInventories(itemStack.getType(), shuffledOutputs)).isEmpty()) continue;
                ItemStack remainingToMove = itemStack.clone();
                for (Inventory outputInventory : validOutputInventories) {
                    HashMap unmovable = outputInventory.addItem(new ItemStack[]{remainingToMove});
                    if (unmovable.isEmpty()) {
                        remainingToMove = null;
                        break;
                    }
                    remainingToMove = (ItemStack)unmovable.get(0);
                }
                if (remainingToMove == null) {
                    inputInventory.setItem(i, null);
                    continue;
                }
                if (remainingToMove.getAmount() == itemStack.getAmount()) continue;
                itemStack.setAmount(remainingToMove.getAmount());
                inputInventory.setItem(i, itemStack);
            }
        }
    }

    private List<Inventory> findValidOutputInventories(Material material, List<PipeNode> potentialOutputs) {
        return potentialOutputs.stream().filter(outputNode -> outputNode.filter() == null || outputNode.filter().isItemAllowed(material)).map(node -> node.holder().getInventory()).collect(Collectors.toList());
    }

    public void save() {
        String basePath = "networks." + this.networkID.toString() + ".";
        List<String> serializedInputNodes = this.inputNodes.stream().map(PipeNode::toString).toList();
        List<String> serializedOutputNodes = this.outputNodes.stream().map(PipeNode::toString).toList();
        Configs.PIPE_DATA.set(basePath + "ownerUUID", this.ownerUUID.toString());
        Configs.PIPE_DATA.set(basePath + "inputNodes", serializedInputNodes);
        Configs.PIPE_DATA.set(basePath + "outputNodes", serializedOutputNodes);
        PipelessPipes.getLog().finer("Saved PipeNetwork %s to config".formatted(this.networkID.toString()));
        PipeSystemWorker.getInstance().reloadNetwork(this.networkID);
    }

    public void save(PipeNode ... nodesToUpdate) {
        for (PipeNode node : nodesToUpdate) {
            ArrayList<PipeNode> targetList = node.isInputNode() ? this.inputNodes : this.outputNodes;
            int index = this.findIndexById(targetList, node.nodeID());
            if (index >= 0) {
                targetList.set(index, node);
            } else {
                targetList.add(node);
            }
            BlockState blockState = node.location().getBlock().getState();
            if (!(blockState instanceof TileStateInventoryHolder)) {
                PipelessPipes.getLog().severe("Node is not anymore a TSIH! PSPI");
                return;
            }
            TileStateInventoryHolder holder = (TileStateInventoryHolder)blockState;
            holder.getPersistentDataContainer().remove(PipeWrenchManager.PIPE_DATA_KEY);
            holder.getPersistentDataContainer().set(PipeWrenchManager.PIPE_DATA_KEY, PersistentDataType.STRING, (Object)node.toString());
            holder.update(true, false);
            this.save();
        }
    }

    private int findIndexById(List<PipeNode> list, UUID nodeID) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).nodeID().equals(nodeID)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PipeNetwork load(String networkID) {
        String basePath = "networks." + networkID + ".";
        String ownerIDString = Configs.PIPE_DATA.getOrDefault(basePath + "ownerUUID", null);
        if (ownerIDString == null || ownerIDString.isEmpty()) {
            PipelessPipes.getLog().warning("Could not load OwnerUUID of PipeNetwork " + networkID);
            return null;
        }
        UUID ownerID = UUID.fromString(ownerIDString);
        ArrayList<PipeNode> inputNodes = new ArrayList<PipeNode>();
        Configs.PIPE_DATA.getStringList(basePath + "inputNodes").forEach(nodeData -> {
            PipeNode node = PipeNode.fromString(nodeData);
            if (node != null) {
                if (!node.isInputNode) {
                    PipelessPipes.getLog().severe("PipeNetwork Node has false Mode. Its a output node in Input loading! " + nodeData);
                    return;
                }
                if (!node.networkID.toString().equals(networkID)) {
                    PipelessPipes.getLog().severe("PipeNetwork ID and Node Network ID are not the same!");
                    return;
                }
                inputNodes.add(node);
            }
        });
        ArrayList<PipeNode> outputNodes = new ArrayList<PipeNode>();
        Configs.PIPE_DATA.getStringList(basePath + "outputNodes").forEach(nodeData -> {
            PipeNode node = PipeNode.fromString(nodeData);
            if (node != null) {
                if (node.isInputNode) {
                    PipelessPipes.getLog().severe("PipeNetwork Node has false Mode. Its a input node in output loading! " + nodeData);
                    return;
                }
                if (!node.networkID.toString().equals(networkID)) {
                    PipelessPipes.getLog().severe("PipeNetwork ID and Node Network ID are not the same!");
                    return;
                }
                outputNodes.add(node);
            }
        });
        return new PipeNetwork(UUID.fromString(networkID), ownerID, inputNodes, outputNodes);
    }

    @Generated
    public UUID getNetworkID() {
        return this.networkID;
    }

    @Generated
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Generated
    public ArrayList<PipeNode> getInputNodes() {
        return this.inputNodes;
    }

    @Generated
    public ArrayList<PipeNode> getOutputNodes() {
        return this.outputNodes;
    }

    @Generated
    public PipeNetwork(UUID networkID, UUID ownerUUID, ArrayList<PipeNode> inputNodes, ArrayList<PipeNode> outputNodes) {
        this.networkID = networkID;
        this.ownerUUID = ownerUUID;
        this.inputNodes = inputNodes;
        this.outputNodes = outputNodes;
    }

    public record PipeNode(UUID networkID, UUID nodeID, Location location, TileStateInventoryHolder holder, boolean isInputNode, @Nullable Filter filter) {
        @Override
        @NotNull
        public String toString() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("networkID", this.networkID.toString());
            jsonObject.addProperty("nodeID", this.nodeID.toString());
            jsonObject.addProperty("world", this.location.getWorld().getName());
            jsonObject.addProperty("x", (Number)this.location.getBlockX());
            jsonObject.addProperty("y", (Number)this.location.getBlockY());
            jsonObject.addProperty("z", (Number)this.location.getBlockZ());
            jsonObject.addProperty("isInputNode", Boolean.valueOf(this.isInputNode));
            if (this.filter != null) {
                jsonObject.add("filter", (JsonElement)this.filter.toJsonObj());
            }
            return jsonObject.toString();
        }

        @Nullable
        public static PipeNode fromString(String data) {
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (!jsonElement.isJsonObject()) {
                PipelessPipes.getLog().severe("Invalid PipeNode format (Not a JSON object): " + data);
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            try {
                World world;
                UUID networkID = UUID.fromString(jsonObject.getAsJsonPrimitive("networkID").getAsString());
                UUID nodeID = UUID.fromString(jsonObject.getAsJsonPrimitive("nodeID").getAsString());
                String worldName = jsonObject.getAsJsonPrimitive("world").getAsString();
                int x = jsonObject.getAsJsonPrimitive("x").getAsInt();
                int y = jsonObject.getAsJsonPrimitive("y").getAsInt();
                int z = jsonObject.getAsJsonPrimitive("z").getAsInt();
                boolean isInput = jsonObject.getAsJsonPrimitive("isInputNode").getAsBoolean();
                Filter filter = null;
                if (jsonObject.has("filter")) {
                    filter = Filter.fromJsonObj(jsonObject.getAsJsonObject("filter"));
                }
                if ((world = Bukkit.getWorld((String)worldName)) == null) {
                    PipelessPipes.getLog().severe("Invalid PipeNode format (world is null): " + data);
                    return null;
                }
                Location location = new Location(world, (double)x, (double)y, (double)z);
                Block block = location.getBlock();
                BlockState blockState = block.getState();
                if (!(blockState instanceof TileStateInventoryHolder)) {
                    PipelessPipes.getLog().severe("Invalid PipeNode! Block at location is not a TileStateInventoryHolder! Block Type: %s Data: %s".formatted(block.getType(), data));
                    return null;
                }
                TileStateInventoryHolder holder = (TileStateInventoryHolder)blockState;
                return new PipeNode(networkID, nodeID, location, holder, isInput, filter);
            }
            catch (Exception e) {
                PipelessPipes.getLog().severe("Could not load PipeNetwork. " + String.valueOf(e));
                return null;
            }
        }

        public static class Filter {
            private boolean isWhitelist;
            private Set<Material> filterItems;

            public boolean isItemAllowed(@NotNull Material material) {
                boolean isItemInSet = this.filterItems.contains(material);
                return this.isWhitelist == isItemInSet;
            }

            @NotNull
            public JsonObject toJsonObj() {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("isWhitelist", Boolean.valueOf(this.isWhitelist));
                JsonArray serializedFilterItems = new JsonArray();
                this.filterItems.stream().map(Enum::name).forEach(arg_0 -> ((JsonArray)serializedFilterItems).add(arg_0));
                jsonObject.add("filterItems", (JsonElement)serializedFilterItems);
                return jsonObject;
            }

            @Nullable
            public static Filter fromJsonObj(JsonObject jsonObject) {
                try {
                    boolean isWhitelist = jsonObject.get("isWhitelist").getAsBoolean();
                    HashSet<Material> filterItems = new HashSet<Material>();
                    JsonArray array = jsonObject.getAsJsonArray("filterItems");
                    for (JsonElement element : array) {
                        try {
                            filterItems.add(Material.valueOf((String)element.getAsString()));
                        }
                        catch (IllegalArgumentException ex) {
                            PipelessPipes.getLog().severe("Cannot add Filter Material. Mat: %s Error: %s".formatted(element.toString(), ex));
                        }
                    }
                    return new Filter(isWhitelist, filterItems);
                }
                catch (Exception e) {
                    PipelessPipes.getLog().severe("Could not load Pipe Filter. " + String.valueOf(e));
                    return null;
                }
            }

            @Generated
            public Filter(boolean isWhitelist, Set<Material> filterItems) {
                this.isWhitelist = isWhitelist;
                this.filterItems = filterItems;
            }

            @Generated
            public boolean isWhitelist() {
                return this.isWhitelist;
            }

            @Generated
            public void setWhitelist(boolean isWhitelist) {
                this.isWhitelist = isWhitelist;
            }

            @Generated
            public Set<Material> getFilterItems() {
                return this.filterItems;
            }
        }
    }
}

