/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.pipelessPipes.Listeners;

import de.tim2byte.pipelessPipes.Network.PipeWrenchManager;
import de.tim2byte.pipelessPipes.PipelessPipes;
import de.tim2byte.pipelessPipes.Util.Messages;
import de.tim2byte.tBLib.item.ItemBuilder;
import io.papermc.paper.block.TileStateInventoryHolder;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class PipeListener
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() == null) {
            return;
        }
        ItemStack itemInUse = event.getItem();
        if (!itemInUse.getType().equals((Object)Material.PLAYER_HEAD)) {
            return;
        }
        if (!ItemBuilder.hasID(itemInUse, "PipelessPipes:pipe_wrench")) {
            return;
        }
        boolean wasCanceled = event.useInteractedBlock().equals((Object)Event.Result.DENY);
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (player.isSneaking() && event.getAction().isLeftClick()) {
            player.getInventory().setItemInMainHand(PipeWrenchManager.getPipeWrenchUndefined(player));
            Messages.TOOL_UNLINKED.send(player);
            return;
        }
        if (wasCanceled) {
            return;
        }
        if (!event.hasBlock()) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        BlockState blockState = event.getClickedBlock().getState();
        if (!(blockState instanceof TileStateInventoryHolder)) {
            return;
        }
        TileStateInventoryHolder holder = (TileStateInventoryHolder)blockState;
        holder = this.getValidHolder(holder);
        event.setCancelled(true);
        PipeWrenchManager.clickContainer(player, itemInUse, holder);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        BlockState blockState = event.getBlock().getState();
        if (!(blockState instanceof TileStateInventoryHolder)) {
            return;
        }
        TileStateInventoryHolder holder = (TileStateInventoryHolder)blockState;
        holder = this.getValidHolder(holder);
        if (holder.getPersistentDataContainer().has(PipeWrenchManager.PIPE_DATA_KEY, PersistentDataType.STRING)) {
            event.setCancelled(true);
            Messages.BREAK_PIPE_CONTAINER.send(event.getPlayer());
        }
    }

    private TileStateInventoryHolder getValidHolder(TileStateInventoryHolder holder) {
        InventoryHolder inventoryHolder = holder.getInventory().getHolder();
        if (inventoryHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            InventoryHolder leftSide = doubleChest.getLeftSide();
            if (leftSide == null) {
                PipelessPipes.getLog().severe("Left site is null?! PipeSystemListener");
                return holder;
            }
            Location leftLocation = leftSide.getInventory().getLocation();
            if (leftLocation == null) {
                PipelessPipes.getLog().severe("Left location is null?! PipeSystemListener");
                return holder;
            }
            BlockState blockState = leftLocation.getBlock().getState();
            if (!(blockState instanceof TileStateInventoryHolder)) {
                PipelessPipes.getLog().severe("Left Block of Location is not an TSIH! PipeSystemListener");
                return holder;
            }
            TileStateInventoryHolder leftHolder = (TileStateInventoryHolder)blockState;
            return leftHolder;
        }
        return holder;
    }
}

