/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.pipelessPipes.GUIs;

import de.tim2byte.pipelessPipes.GUIs.PipeFilterGUI;
import de.tim2byte.pipelessPipes.Network.PipeNetwork;
import de.tim2byte.pipelessPipes.PipelessPipes;
import de.tim2byte.pipelessPipes.Util.Messages;
import de.tim2byte.tBLib.GUI.TBCustomGUI;
import de.tim2byte.tBLib.Utils.StringUtils;
import de.tim2byte.tBLib.item.ItemBuilder;
import io.papermc.paper.block.TileStateInventoryHolder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeGUI
extends TBCustomGUI {
    private final PipeNetwork pipeNetwork;
    @Nullable
    private PipeNetwork.PipeNode pipeNode;
    private final TileStateInventoryHolder holder;

    public PipeGUI(Player player, @NotNull PipeNetwork pipeNetwork, @Nullable PipeNetwork.PipeNode pipeNode, TileStateInventoryHolder holder, String page) {
        super(player, page, () -> {
            switch (page) {
                case "undefined_container": 
                case "open_input_node": 
                case "open_output_node": 
                case "manage_filter": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + page);
                }
            }
            return 9;
        }, () -> switch (page) {
            case "undefined_container" -> Messages.GUI_DEFINE.getMessage(player);
            case "open_input_node" -> Messages.GUI_INPUT_SETTINGS.getMessage(player);
            case "open_output_node" -> Messages.GUI_OUTPUT_SETTINGS.getMessage(player);
            case "manage_filter" -> Messages.GUI_FILTER_SETTINGS.getMessage(player);
            default -> throw new IllegalStateException("Unexpected value: " + page);
        }, Material.BLUE_STAINED_GLASS_PANE);
        this.pipeNetwork = pipeNetwork;
        this.pipeNode = pipeNode;
        this.holder = holder;
        switch (page) {
            case "undefined_container": {
                this.clickable(2, new ItemBuilder(Material.HOPPER).setName(Messages.GUI_DEFINE_INPUT_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_DEFINE_INPUT_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    PipeNetwork.PipeNode node = new PipeNetwork.PipeNode(pipeNetwork.getNetworkID(), pipeNetwork.getFreeNodeID(), holder.getLocation(), holder, true, null);
                    pipeNetwork.addNode(node, holder, player);
                    this.pipeNode = node;
                });
                this.clickable(6, new ItemBuilder(Material.DROPPER).setName(Messages.GUI_DEFINE_OUTPUT_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_DEFINE_OUTPUT_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    PipeNetwork.PipeNode node = new PipeNetwork.PipeNode(pipeNetwork.getNetworkID(), pipeNetwork.getFreeNodeID(), holder.getLocation(), holder, false, new PipeNetwork.PipeNode.Filter(true, new HashSet<Material>()));
                    pipeNetwork.addNode(node, holder, player);
                    this.pipeNode = node;
                });
                break;
            }
            case "open_input_node": {
                if (pipeNode == null) {
                    PipelessPipes.getLog().severe("Opening Input Node GUI without a valid Node!");
                    player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 245");
                    return;
                }
                this.clickable(2, new ItemBuilder(Material.DROPPER).setName(Messages.GUI_CHANGE_INPUT_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_CHANGE_INPUT_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    pipeNetwork.removeNode(pipeNode, holder);
                    PipeNetwork.PipeNode newNode = new PipeNetwork.PipeNode(pipeNode.networkID(), pipeNode.nodeID(), pipeNode.location(), pipeNode.holder(), false, new PipeNetwork.PipeNode.Filter(true, new HashSet<Material>()));
                    pipeNetwork.addNode(newNode, holder, player);
                    Messages.CONVERT_INPUT_SUCCESS.send(player);
                });
                this.clickable(6, new ItemBuilder(Material.RED_CONCRETE).setName(Messages.GUI_REMOVE_NODE_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_REMOVE_NODE_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    pipeNetwork.removeNode(pipeNode, holder);
                    player.closeInventory();
                    Messages.REMOVED_PIPE.send(player);
                });
                break;
            }
            case "open_output_node": {
                if (pipeNode == null) {
                    PipelessPipes.getLog().severe("Opening Output Node GUI without a valid Node!");
                    player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 246");
                    return;
                }
                this.clickable(2, new ItemBuilder(Material.DROPPER).setName(Messages.GUI_CHANGE_OUTPUT_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_CHANGE_OUTPUT_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    pipeNetwork.removeNode(pipeNode, holder);
                    PipeNetwork.PipeNode newNode = new PipeNetwork.PipeNode(pipeNode.networkID(), pipeNode.nodeID(), pipeNode.location(), pipeNode.holder(), true, null);
                    pipeNetwork.addNode(newNode, holder, player);
                    Messages.CONVERT_OUTPUT_SUCCESS.send(player);
                });
                this.openPage("manage_filter", 4, new ItemBuilder(Material.PAPER).setName(Messages.GUI_MANAGE_FILTERS_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_MANAGE_FILTERS_LORE.getMessage(player), 26, "<gray>")).build());
                this.clickable(6, new ItemBuilder(Material.RED_CONCRETE).setName(Messages.GUI_REMOVE_NODE_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_REMOVE_NODE_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    pipeNetwork.removeNode(pipeNode, holder);
                    player.closeInventory();
                    Messages.REMOVED_PIPE.send(player);
                });
                break;
            }
            case "manage_filter": {
                if (pipeNode == null) {
                    PipelessPipes.getLog().severe("Opening Filter GUI without a valid Node!");
                    player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 247");
                    return;
                }
                PipeNetwork.PipeNode.Filter filter = pipeNode.filter();
                if (filter == null) {
                    PipelessPipes.getLog().severe("Opening Filter Node GUI without a valid Filter!");
                    player.sendRichMessage("<red>PipeSystem | Please contract an Admin! Error Code: 248");
                    return;
                }
                if (filter.isWhitelist()) {
                    this.clickable(0, new ItemBuilder(Material.WHITE_DYE).setName(Messages.GUI_FILTER_WHITELIST_TITLE.getMessage(player)).addLore(Messages.GUI_FILTER_WHITELIST_LORE_1.getMessage(player), StringUtils.splitIntoSegments(Messages.GUI_FILTER_WHITELIST_LORE_2.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                        filter.setWhitelist(false);
                        pipeNetwork.save(pipeNode);
                        player.openInventory(new PipeGUI(player, pipeNetwork, pipeNode, holder, "manage_filter").getInventory());
                    });
                } else {
                    this.clickable(0, new ItemBuilder(Material.WHITE_DYE).setName(Messages.GUI_FILTER_BLACKLIST_TITLE.getMessage(player)).addLore(Messages.GUI_FILTER_BLACKLIST_LORE_1.getMessage(player), StringUtils.splitIntoSegments(Messages.GUI_FILTER_BLACKLIST_LORE_2.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                        filter.setWhitelist(true);
                        pipeNetwork.save(pipeNode);
                        player.openInventory(new PipeGUI(player, pipeNetwork, pipeNode, holder, "manage_filter").getInventory());
                    });
                }
                Material handMaterial = player.getInventory().getItemInOffHand().isEmpty() ? Material.BARRIER : player.getInventory().getItemInOffHand().getType();
                Object handItemName = player.getInventory().getItemInOffHand().isEmpty() ? Messages.GUI_NO_ITEM_IN_OFFHAND.getMessage(player) : "<lang:" + handMaterial.getItemTranslationKey() + ">";
                this.clickable(2, new ItemBuilder(handMaterial).setName(Messages.GUI_FILTER_OFFHAND_ADD_TITLE.getMessage(player)).addLore(Messages.GUI_FILTER_OFFHAND_ADD_LORE_1.getMessage(player) + (String)handItemName, StringUtils.splitIntoSegments(Messages.GUI_FILTER_OFFHAND_ADD_LORE_2.getMessage(player), 26, "<gray>")).addLoreIf(filter.getFilterItems().contains(handMaterial), StringUtils.splitIntoSegments(Messages.GUI_FILTER_OFFHAND_ADD_WARNING.getMessage(player), 26, "<red>")).build(), (arg_0, arg_1) -> PipeGUI.lambda$new$10(handMaterial, player, filter, (String)handItemName, pipeNode, pipeNetwork, arg_0, arg_1));
                ArrayList<CallSite> foundItemNames = new ArrayList<CallSite>();
                ArrayList<Material> foundItemMats = new ArrayList<Material>();
                for (ItemStack content : holder.getInventory().getContents()) {
                    String name;
                    if (content == null || content.isEmpty() || foundItemNames.contains(name = "<white><lang:" + content.getType().getItemTranslationKey() + ">") || filter.getFilterItems().contains(content.getType())) continue;
                    foundItemNames.add((CallSite)((Object)name));
                    foundItemMats.add(content.getType());
                }
                this.clickable(3, new ItemBuilder(Material.CHEST_MINECART).setName(Messages.GUI_FILTER_CONTAINER_ADD_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_FILTER_CONTAINER_ADD_LORE_1.getMessage(player), 26, "<gray>"), Messages.GUI_FILTER_CONTAINER_ADD_LORE_2.getMessage(player), foundItemNames).build(), (item, event) -> {
                    for (Material matToAdd : foundItemMats) {
                        if (filter.getFilterItems().contains(matToAdd)) {
                            Messages.ERROR_ALREADY_IN_FILTER.send(player);
                            player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                            return;
                        }
                        filter.getFilterItems().add(matToAdd);
                        PipelessPipes.getLog().info("PipeSystem | Added item %s to Filter in Node %s at Network %s".formatted(matToAdd, pipeNode.nodeID(), pipeNetwork.getNetworkID()));
                        player.closeInventory();
                        player.sendRichMessage(Messages.ADDED_ITEM_TO_FILTER.getMessage(player).replace("%ITEM%", "<lang:" + matToAdd.getItemTranslationKey() + ">"));
                    }
                    pipeNetwork.save(pipeNode);
                });
                this.inventory.setItem(4, new ItemBuilder(Material.WRITABLE_BOOK).setName(Messages.GUI_FILTER_CHAT_ADD_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_FILTER_CHAT_ADD_LORE.getMessage(player), 26, "<gray>")).build());
                this.clickable(6, new ItemBuilder(Material.ENDER_EYE).setName(Messages.GUI_FILTER_SHOW_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_FILTER_SHOW_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    player.closeInventory();
                    player.openInventory(new PipeFilterGUI(player, 0, pipeNetwork, pipeNode, filter).getInventory());
                });
                this.clickable(8, new ItemBuilder(Material.RED_WOOL).setName(Messages.GUI_FILTER_RESET_TITLE.getMessage(player)).addLore(StringUtils.splitIntoSegments(Messages.GUI_FILTER_RESET_LORE.getMessage(player), 26, "<gray>")).build(), (item, event) -> {
                    filter.getFilterItems().clear();
                    PipelessPipes.getLog().info("PipeSystem | cleared filter from Network: " + String.valueOf(pipeNetwork.getNetworkID()));
                    pipeNetwork.save(pipeNode);
                    player.closeInventory();
                    Messages.PIPE_FILTER_RESET_SUCCESS.send(player);
                });
            }
        }
    }

    @Override
    public TBCustomGUI getNewInstance(String s) {
        return new PipeGUI(this.player, this.pipeNetwork, this.pipeNode, this.holder, s);
    }

    private static /* synthetic */ void lambda$new$10(Material handMaterial, Player player, PipeNetwork.PipeNode.Filter filter, String handItemName, PipeNetwork.PipeNode pipeNode, PipeNetwork pipeNetwork, ItemStack item, InventoryClickEvent event) {
        if (handMaterial.equals((Object)Material.BARRIER)) {
            Messages.GUI_NO_ITEM_IN_OFFHAND.send(player);
            player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            return;
        }
        if (filter.getFilterItems().contains(handMaterial)) {
            Messages.ERROR_ALREADY_IN_FILTER.send(player);
            player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            return;
        }
        filter.getFilterItems().add(handMaterial);
        PipelessPipes.getLog().info("PipeSystem | Added item %s to Filter in Node %s at Network %s".formatted(handItemName, pipeNode.nodeID(), pipeNetwork.getNetworkID()));
        pipeNetwork.save(pipeNode);
        player.closeInventory();
        player.sendRichMessage(Messages.ADDED_ITEM_TO_FILTER.getMessage(player).replace("%ITEM%", handItemName));
    }
}

