/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.pipelessPipes.Commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.tim2byte.pipelessPipes.Network.PipeNetwork;
import de.tim2byte.pipelessPipes.Network.PipeWrenchManager;
import de.tim2byte.pipelessPipes.PipelessPipes;
import de.tim2byte.pipelessPipes.Util.Messages;
import de.tim2byte.tBLib.Commands.TBCommand;
import de.tim2byte.tBLib.Utils.MessageHelper;
import io.papermc.paper.block.TileStateInventoryHolder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class PipeCommand
implements TBCommand {
    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder nodeBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pipe").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "PipelessPipes.command.pipe"))).then(((LiteralArgumentBuilder)Commands.literal((String)"addFilterItem").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "PipelessPipes.command.pipe.addFilterItem"))).then(Commands.argument((String)"Item", (ArgumentType)ArgumentTypes.itemStack()).executes(context -> {
            Player executor = this.getExecutingPlayer((CommandContext<CommandSourceStack>)context);
            ItemStack itemStack = (ItemStack)context.getArgument("Item", ItemStack.class);
            if (itemStack.isEmpty()) {
                Messages.ERROR_NO_ITEM.send(executor);
                return 1;
            }
            Block block = executor.getTargetBlock(null, 5);
            BlockState patt0$temp = block.getState();
            if (!(patt0$temp instanceof TileStateInventoryHolder)) {
                Messages.ERROR_NO_CONTAINER.send(executor);
                return 1;
            }
            TileStateInventoryHolder holder = (TileStateInventoryHolder)patt0$temp;
            InventoryHolder patt1$temp = holder.getInventory().getHolder();
            if (patt1$temp instanceof DoubleChest) {
                DoubleChest doubleChest = (DoubleChest)patt1$temp;
                InventoryHolder leftSide = doubleChest.getLeftSide();
                if (leftSide == null) {
                    PipelessPipes.getLog().severe("Left site is null?! PipeSystemListener");
                    return 1;
                }
                Location leftLocation = leftSide.getInventory().getLocation();
                if (leftLocation == null) {
                    PipelessPipes.getLog().severe("Left location is null?! PipeSystemListener");
                    return 1;
                }
                BlockState patt2$temp = leftLocation.getBlock().getState();
                if (!(patt2$temp instanceof TileStateInventoryHolder)) {
                    PipelessPipes.getLog().severe("Left Block of Location is not an TSIH! PipeSystemListener");
                    return 1;
                }
                TileStateInventoryHolder leftHolder = (TileStateInventoryHolder)patt2$temp;
                holder = leftHolder;
            }
            if (!holder.getPersistentDataContainer().has(PipeWrenchManager.PIPE_DATA_KEY, PersistentDataType.STRING)) {
                Messages.ERROR_NO_PIPENODE.send(executor);
                return 1;
            }
            String data = (String)holder.getPersistentDataContainer().get(PipeWrenchManager.PIPE_DATA_KEY, PersistentDataType.STRING);
            PipeNetwork.PipeNode pipeNode = PipeNetwork.PipeNode.fromString(data);
            if (pipeNode == null) {
                Messages.ERROR_NO_PIPENODE.send(executor);
                return 1;
            }
            if (pipeNode.isInputNode()) {
                Messages.ERROR_NO_OUTPUT_PIPE.send(executor);
                return 1;
            }
            PipeNetwork.PipeNode.Filter filter = pipeNode.filter();
            if (filter == null) {
                return 1;
            }
            PipeNetwork pipeNetwork = PipeNetwork.load(pipeNode.networkID().toString());
            if (pipeNetwork == null) {
                return 1;
            }
            if (filter.getFilterItems().contains(itemStack.getType())) {
                Messages.ERROR_ALREADY_IN_FILTER.send(executor);
                return 1;
            }
            filter.getFilterItems().add(itemStack.getType());
            pipeNetwork.save(pipeNode);
            executor.sendRichMessage(Messages.ADDED_ITEM_TO_FILTER.getMessage(executor).replace("%ITEM%", "<lang:" + itemStack.translationKey() + ">"));
            Messages.ADDED_ITEM_TO_FILTER.send(executor);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"setLanguage").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "PipelessPipes.command.language"))).then(Commands.argument((String)"Language", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> this.stringSuggest(builder, () -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add("englisch");
            list.add("deutsch");
            return list;
        })).executes(context -> {
            Player executor = this.getExecutingPlayer((CommandContext<CommandSourceStack>)context);
            String language = StringArgumentType.getString((CommandContext)context, (String)"Language");
            if (language == null || language.isBlank() || !language.equalsIgnoreCase("englisch") && !language.equalsIgnoreCase("deutsch")) {
                Messages.FALSE_LANGUAGE.send(executor);
                return 1;
            }
            switch (language.toLowerCase()) {
                case "englisch": {
                    MessageHelper.setPlayerLanguage(executor, MessageHelper.Language.ENGLISH);
                    break;
                }
                case "deutsch": {
                    MessageHelper.setPlayerLanguage(executor, MessageHelper.Language.GERMAN);
                }
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"givePipeTool").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "PipelessPipes.command.pipe.admin"))).executes(context -> {
            Player executor = this.getExecutingPlayer((CommandContext<CommandSourceStack>)context);
            executor.getInventory().addItem(new ItemStack[]{PipeWrenchManager.getPipeWrenchUndefined(executor).clone()});
            return 1;
        }));
        return nodeBuilder.build();
    }
}

