/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.item.Recipe;

import de.tim2byte.tBLib.Utils.InventoryUtils;
import de.tim2byte.tBLib.item.Recipe.TBRecipe;
import de.tim2byte.tBLib.item.Recipe.TBRecipeHelper;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TBRecipeListener
implements Listener {
    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        if (event.isRepair()) {
            return;
        }
        ItemStack[] matrix = event.getInventory().getMatrix();
        List<Material> materialKey = TBRecipeHelper.matrixToKey(matrix);
        List<TBRecipe> potentialMatches = TBRecipeHelper.getRegisteredRecipes().get(materialKey);
        if (potentialMatches == null || potentialMatches.isEmpty()) {
            return;
        }
        for (TBRecipe tbRecipe : potentialMatches) {
            if (!this.isExactTBRecipe(tbRecipe.matrix(), matrix)) continue;
            event.getInventory().setResult(tbRecipe.result());
            return;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inventory2 = (CraftingInventory)inventory;
        if (event.getRawSlot() != 0) {
            return;
        }
        ItemStack result = inventory2.getResult();
        if (result == null || result.getType() == Material.AIR) {
            return;
        }
        ItemStack[] matrix = inventory2.getMatrix();
        List<Material> materialKey = TBRecipeHelper.matrixToKey(matrix);
        List<TBRecipe> potentialMatches = TBRecipeHelper.getRegisteredRecipes().get(materialKey);
        if (potentialMatches == null || potentialMatches.isEmpty()) {
            return;
        }
        for (TBRecipe tbRecipe : potentialMatches) {
            if (!this.isExactTBRecipe(tbRecipe.matrix(), matrix)) continue;
            inventory2.clear();
            if (event.isShiftClick()) {
                InventoryUtils.giveItemOrDrop(event.getWhoClicked().getInventory(), tbRecipe.result().clone());
            } else {
                event.getWhoClicked().setItemOnCursor(tbRecipe.result().clone());
            }
            return;
        }
    }

    private boolean isExactTBRecipe(List<ItemStack> recipeMatrix, ItemStack[] inputMatrix) {
        for (int i = 0; i < 9; ++i) {
            ItemStack recipeItem = recipeMatrix.get(i);
            ItemStack inputItem = inputMatrix[i];
            if (recipeItem == null || recipeItem.getType() == Material.AIR || inputItem == null || inputItem.getType() == Material.AIR) continue;
            if (recipeItem.getAmount() != inputItem.getAmount()) {
                return false;
            }
            if (recipeItem.isSimilar(inputItem)) continue;
            return false;
        }
        return true;
    }
}

