/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.item.Recipe;

import de.tim2byte.tBLib.TBLib;
import de.tim2byte.tBLib.item.Recipe.TBRecipe;
import de.tim2byte.tBLib.item.Recipe.TBRecipeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class TBRecipeHelper {
    private static final Map<List<Material>, List<TBRecipe>> registeredRecipes = new HashMap<List<Material>, List<TBRecipe>>();
    private static final Map<String, TBRecipe> registeredRecipesNames = new HashMap<String, TBRecipe>();

    public static void setup() {
        JavaPlugin plugin = TBLib.getPlugin();
        plugin.getServer().getPluginManager().registerEvents((Listener)new TBRecipeListener(), (Plugin)plugin);
    }

    public static void register(TBRecipe tbRecipe) {
        List<Material> key = TBRecipeHelper.matrixToKey(tbRecipe.matrix());
        registeredRecipes.computeIfAbsent(key, list -> new ArrayList()).add(tbRecipe);
        registeredRecipesNames.put(tbRecipe.recipeName(), tbRecipe);
    }

    public static List<Material> matrixToKey(ItemStack[] matrix) {
        ArrayList<Material> layout = new ArrayList<Material>(9);
        for (ItemStack item : matrix) {
            layout.add(item == null ? Material.AIR : item.getType());
        }
        return layout;
    }

    public static List<Material> matrixToKey(List<ItemStack> matrix) {
        ArrayList<Material> layout = new ArrayList<Material>(9);
        for (ItemStack item : matrix) {
            layout.add(item == null ? Material.AIR : item.getType());
        }
        return layout;
    }

    @NotNull
    public static TBRecipe getRecipeByName(String string) {
        TBRecipe tbRecipe = registeredRecipesNames.get(string);
        if (tbRecipe == null) {
            throw new RuntimeException("No TBRecipe found with this name!");
        }
        return tbRecipe;
    }

    @Generated
    public static Map<List<Material>, List<TBRecipe>> getRegisteredRecipes() {
        return registeredRecipes;
    }
}

