/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.Utils;

import de.tim2byte.tBLib.Config.CConfig;
import de.tim2byte.tBLib.TBLib;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public interface MessageHelper {
    public static final NamespacedKey LANG_KEY = new NamespacedKey("tblib", "language");
    public static final ConcurrentHashMap<UUID, Language> LANG_CACHE = new ConcurrentHashMap();
    public static final CConfig ENGLISH_CONFIG = new CConfig("plugins/" + TBLib.getPlugin().getName() + "/lang", "default.yml");
    public static final CConfig GERMAN_CONFIG = new CConfig("plugins/" + TBLib.getPlugin().getName() + "/lang", "deutsch.yml");

    public String getDefaultEnglish();

    public String getDefaultGerman();

    public String name();

    default public void send(@NotNull Player player) {
        player.sendRichMessage(this.getMessage(player));
    }

    default public String getMessage(@NotNull Player player) {
        Language lang = MessageHelper.getPlayerLanguage(player);
        return switch (lang.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ENGLISH_CONFIG.getOrSetDefault(this.name(), this.getDefaultEnglish());
            case 1 -> GERMAN_CONFIG.getOrSetDefault(this.name(), this.getDefaultGerman());
        };
    }

    public static Language getPlayerLanguage(@NotNull Player player) {
        return LANG_CACHE.computeIfAbsent(player.getUniqueId(), uuid -> {
            String langName = (String)player.getPersistentDataContainer().get(LANG_KEY, PersistentDataType.STRING);
            if (langName != null) {
                try {
                    return Language.valueOf(langName.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return Language.ENGLISH;
        });
    }

    public static void setPlayerLanguage(@NotNull Player player, @NotNull Language language) {
        LANG_CACHE.put(player.getUniqueId(), language);
        player.getPersistentDataContainer().set(LANG_KEY, PersistentDataType.STRING, (Object)language.name());
    }

    public static void clearCacheForPlayer(@NotNull Player player) {
        LANG_CACHE.remove(player.getUniqueId());
    }

    public static void setup(@NotNull Supplier<MessageHelper[]> messagesSupplier) {
        MessageHelper[] messages = messagesSupplier.get();
        if (messages == null) {
            return;
        }
        Arrays.stream(messages).forEach(message -> {
            if (!ENGLISH_CONFIG.contains(message.name())) {
                ENGLISH_CONFIG.set(message.name(), message.getDefaultEnglish());
            }
            if (!GERMAN_CONFIG.contains(message.name())) {
                GERMAN_CONFIG.set(message.name(), message.getDefaultGerman());
            }
        });
        ENGLISH_CONFIG.save();
        GERMAN_CONFIG.save();
    }

    public static enum Language {
        ENGLISH,
        GERMAN;

    }
}

