/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.Utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class InventoryUtils {
    public static int getSimilarItems(Inventory inventory, ItemStack searchedItem) {
        if (inventory == null || searchedItem == null) {
            return 0;
        }
        ItemStack cleanedInputItem = InventoryUtils.cleanItemStack(searchedItem);
        return Arrays.stream(inventory.getContents()).filter(Objects::nonNull).filter(item -> !item.getType().isAir()).map(InventoryUtils::cleanItemStack).filter(cleanItem -> cleanItem.isSimilar(cleanedInputItem)).mapToInt(ItemStack::getAmount).sum();
    }

    public static boolean removeSimilarItems(Inventory inventory, ItemStack searchedItem, int amount) {
        if (inventory == null || searchedItem == null || amount <= 0) {
            return false;
        }
        if (InventoryUtils.getSimilarItems(inventory, searchedItem) < amount) {
            return false;
        }
        ItemStack cleanedInputItem = InventoryUtils.cleanItemStack(searchedItem);
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack currentItem = contents[i];
            if (currentItem == null || currentItem.getType().isAir() || !InventoryUtils.cleanItemStack(currentItem).isSimilar(cleanedInputItem)) continue;
            int toRemove = Math.min(currentItem.getAmount(), amount);
            currentItem.setAmount(currentItem.getAmount() - toRemove);
            amount -= toRemove;
            if (currentItem.getAmount() <= 0) {
                contents[i] = null;
            }
            if (amount <= 0) break;
        }
        inventory.setContents(contents);
        return amount <= 0;
    }

    public static ItemStack cleanItemStack(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return item;
        }
        ItemStack workItem = item.clone();
        ItemMeta itemMeta = workItem.getItemMeta();
        if (itemMeta instanceof Repairable) {
            Repairable repairable = (Repairable)itemMeta;
            repairable.setRepairCost(0);
            workItem.setItemMeta((ItemMeta)repairable);
        }
        if ((itemMeta = workItem.getItemMeta()) instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage(0);
            workItem.setItemMeta((ItemMeta)damageable);
        }
        return workItem;
    }

    public static void giveItemOrDrop(Inventory inventory, Location location, ItemStack ... itemStacks) {
        HashMap leftOver = inventory.addItem(itemStacks);
        if (!leftOver.isEmpty()) {
            leftOver.forEach((integer, itemStack) -> location.getWorld().dropItem(location, itemStack));
        }
    }

    public static void giveItemOrDrop(PlayerInventory inventory, ItemStack ... itemStacks) {
        HashMap leftOver = inventory.addItem(itemStacks);
        HumanEntity holder = inventory.getHolder();
        if (holder == null) {
            throw new RuntimeException("Could not drop Items! Holder seems to be Null. Please report this to the Developer!");
        }
        if (!leftOver.isEmpty()) {
            leftOver.forEach((integer, itemStack) -> holder.getWorld().dropItem(holder.getLocation(), itemStack));
        }
    }
}

