/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.GUI;

import de.tim2byte.tBLib.TBLib;
import de.tim2byte.tBLib.item.ItemBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TBPaginatedGUI
implements InventoryHolder {
    protected static final MiniMessage mm = MiniMessage.miniMessage();
    protected final Player player;
    protected final int page;
    protected final Inventory inventory;
    private final Consumer<ItemStack> onContentClick;

    public TBPaginatedGUI(Player player, int page, int size, String title, @Nullable Material panelMaterial, List<ItemStack> content, Consumer<ItemStack> onClick) {
        this.player = player;
        this.page = page;
        this.inventory = TBLib.getPlugin().getServer().createInventory((InventoryHolder)this, size, mm.deserialize((Object)title));
        this.onContentClick = onClick;
        panelMaterial = panelMaterial != null ? panelMaterial : Material.GRAY_STAINED_GLASS_PANE;
        int itemsPerPage = size - 9;
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, content.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack baseItem = content.get(i);
            if (baseItem == null) continue;
            if (!baseItem.getType().isAir()) {
                baseItem = new ItemBuilder(baseItem.clone()).setExtraData("gui_item", "clickable").build();
            }
            int slot = i - startIndex;
            this.inventory.setItem(slot, baseItem);
        }
        for (int slot = this.inventory.getSize() - 9; slot < this.inventory.getSize(); ++slot) {
            ItemStack fillItem = new ItemBuilder(panelMaterial).setName(" ").setExtraData("gui_item", "background_fill").build();
            this.inventory.setItem(slot, fillItem);
        }
        int maxPages = (int)Math.ceil((double)content.size() / (double)itemsPerPage);
        if (page > 0) {
            this.setNavigationItem(this.inventory.getSize() - 9, page - 1, "<white>Vorherige Seite");
        }
        if (page < maxPages - 1) {
            this.setNavigationItem(this.inventory.getSize() - 1, page + 1, "<white>N\u00e4chste Seite");
        }
    }

    public TBPaginatedGUI(Player player, int page, Supplier<Integer> size, String title, @Nullable Material panelMaterial, List<ItemStack> content, Consumer<ItemStack> onClick) {
        this(player, page, size.get(), title, panelMaterial, content, onClick);
    }

    public TBPaginatedGUI(Player player, int page, String title, @Nullable Material panelMaterial, List<ItemStack> content, Consumer<ItemStack> onClick) {
        this(player, page, () -> {
            int size = content.size();
            int rounded = (size + 8) / 9 * 9 + 9;
            return Math.max(9, Math.min(rounded, 54));
        }, title, panelMaterial, content, onClick);
    }

    private void setNavigationItem(int slot, int targetPage, String name) {
        ItemStack navigationItem = new ItemBuilder(Material.ARROW).setName(mm.deserialize((Object)name)).setExtraData("gui_item", "navigation").setExtraData("navigation", PersistentDataType.INTEGER, Integer.valueOf(targetPage)).build();
        this.inventory.setItem(slot, navigationItem);
    }

    public void handleEventClick(InventoryClickEvent event) {
        event.setCancelled(true);
        @NotNull ItemStack item = Objects.requireNonNull(event.getCurrentItem());
        if (ItemBuilder.getExtraData(item, "gui_item").equals("clickable")) {
            this.onContentClick.accept(item);
        }
        if (ItemBuilder.getExtraData(item, "gui_item").equals("navigation")) {
            int targetPage = ItemBuilder.getExtraData(item, "navigation", PersistentDataType.INTEGER, Integer.valueOf(-1));
            if (targetPage >= 0) {
                this.player.openInventory(this.getNewInstance(targetPage).getInventory());
            }
            return;
        }
        this.onClick(event, item);
    }

    protected void onClick(InventoryClickEvent event, ItemStack clickedItem) {
    }

    public abstract TBPaginatedGUI getNewInstance(int var1);

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

