/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.tBLib.GUI;

import de.tim2byte.tBLib.TBLib;
import de.tim2byte.tBLib.item.ItemBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public abstract class TBCustomGUI
implements InventoryHolder {
    protected static final MiniMessage mm = MiniMessage.miniMessage();
    protected final Player player;
    protected final String page;
    protected final Inventory inventory;
    private final HashMap<Integer, BiConsumer<@NotNull ItemStack, @NotNull InventoryClickEvent>> actionConsumers = new HashMap();

    public TBCustomGUI(Player player, String page, int size, String title, Material ... backgroundFill) {
        this.player = player;
        this.page = page == null || page.isEmpty() ? "default" : page;
        this.inventory = TBLib.getPlugin().getServer().createInventory((InventoryHolder)this, size, mm.deserialize((Object)title));
        if (backgroundFill != null && backgroundFill.length > 0) {
            for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
                Material mat = backgroundFill[slot % backgroundFill.length];
                if (mat == null || mat.isAir()) continue;
                ItemStack fillItem = new ItemBuilder(mat).setName(" ").setExtraData("gui_item", "background_fill").build();
                this.inventory.setItem(slot, fillItem);
            }
        }
    }

    public TBCustomGUI(Player player, String page, Supplier<Integer> size, Supplier<String> title, Material ... backgroundFill) {
        this(player, page, size.get(), title.get(), backgroundFill);
    }

    public void getBackgroundItems(BiConsumer<Integer, @NotNull ItemStack> backgroundItemHandler) {
        IntStream.range(0, this.inventory.getSize()).forEach(slot -> {
            ItemStack item = this.inventory.getItem(slot);
            if (item != null && !item.getType().isAir() && "background_fill".equals(ItemBuilder.getExtraData(item, "gui_item"))) {
                backgroundItemHandler.accept(slot, item);
            }
        });
    }

    protected void openPage(String page, int slot, ItemStack displayItem) {
        this.clickable(slot, displayItem, (item, event) -> this.player.openInventory(this.getNewInstance(page).getInventory()));
    }

    protected void openInventory(Inventory inventory, int slot, ItemStack displayItem) {
        this.clickable(slot, displayItem, (item, event) -> this.player.openInventory(inventory));
    }

    protected void clickable(int slot, ItemStack displayItem, BiConsumer<@NotNull ItemStack, @NotNull InventoryClickEvent> onClick) {
        int actionId = this.actionConsumers.size();
        this.inventory.setItem(slot, new ItemBuilder(displayItem).setExtraData("gui_item", "clickable").setExtraData("clickable_id", PersistentDataType.INTEGER, Integer.valueOf(actionId)).build());
        this.actionConsumers.put(actionId, onClick);
    }

    public void handleEventClick(InventoryClickEvent event) {
        event.setCancelled(true);
        @NotNull ItemStack item = Objects.requireNonNull(event.getCurrentItem());
        if (ItemBuilder.getExtraData(item, "gui_item").equals("clickable")) {
            int clickable_id = ItemBuilder.getExtraData(item, "clickable_id", PersistentDataType.INTEGER, Integer.valueOf(-1));
            this.actionConsumers.get(clickable_id).accept(item, event);
        }
        this.onClick(event, item);
    }

    protected void onClick(InventoryClickEvent event, ItemStack clickedItem) {
    }

    public abstract TBCustomGUI getNewInstance(String var1);

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

