/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.advancedBeacons.Listeners;

import de.tim2byte.advancedBeacons.Beacon.AdvancedBeacon;
import de.tim2byte.advancedBeacons.Beacon.BeaconGUI;
import de.tim2byte.advancedBeacons.Beacon.BeaconManager;
import de.tim2byte.tBLib.item.ItemBuilder;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Beacon;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class BeaconListener
implements Listener {
    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.BEACON)) {
            return;
        }
        if (!event.getItemInHand().getType().equals((Object)Material.BEACON)) {
            return;
        }
        ItemStack item = event.getItemInHand();
        if (!ItemBuilder.hasExtraData(item, BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER)) {
            return;
        }
        int tier = ItemBuilder.getExtraData(item, BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER, Integer.valueOf(-1));
        Beacon beacon = (Beacon)event.getBlock().getState();
        PersistentDataContainer container = beacon.getPersistentDataContainer();
        container.set(BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER, (Object)tier);
        beacon.update(true, false);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.BEACON)) {
            return;
        }
        Beacon beacon = (Beacon)event.getBlock().getState();
        PersistentDataContainer container = beacon.getPersistentDataContainer();
        if (!container.has(BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER)) {
            return;
        }
        int tier = (Integer)container.getOrDefault(BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER, (Object)-1);
        AdvancedBeacon advancedBeacon = AdvancedBeacon.getAdvancedBeacon(beacon);
        advancedBeacon.unregister();
        event.setDropItems(false);
        if (!event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
            beacon.getWorld().dropItemNaturally(beacon.getLocation(), BeaconManager.getBeaconItem(tier));
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getClickedBlock() == null || event.getClickedBlock().getType().isAir()) {
            return;
        }
        if (!event.getClickedBlock().getType().equals((Object)Material.BEACON)) {
            return;
        }
        Beacon beacon = (Beacon)event.getClickedBlock().getState();
        PersistentDataContainer container = beacon.getPersistentDataContainer();
        if (!container.has(BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER)) {
            return;
        }
        AdvancedBeacon advancedBeacon = AdvancedBeacon.getAdvancedBeacon(beacon);
        event.setCancelled(true);
        event.getPlayer().openInventory(new BeaconGUI(event.getPlayer(), advancedBeacon, "default").getInventory());
    }
}

