/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.advancedBeacons.Commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.tim2byte.advancedBeacons.Beacon.BeaconManager;
import de.tim2byte.tBLib.Commands.TBCommand;
import de.tim2byte.tBLib.Utils.InventoryUtils;
import de.tim2byte.tBLib.Utils.MessageHelper;
import de.tim2byte.tBLib.item.Recipe.TBRecipe;
import de.tim2byte.tBLib.item.Recipe.TBRecipeHelper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import org.bukkit.entity.Player;

public class BaseCommand
implements TBCommand {
    @Override
    public LiteralCommandNode<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder nodeBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"advancedbeacons").then(((LiteralArgumentBuilder)Commands.literal((String)"setLanguage").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "advancedbeacons.command.setlanguage"))).then(Commands.argument((String)"Language", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> this.stringSuggest(builder, () -> List.of("English", "Deutsch"))).executes(context -> {
            Player executor = this.getExecutingPlayer((CommandContext<CommandSourceStack>)context);
            String language = StringArgumentType.getString((CommandContext)context, (String)"Language");
            if (language == null || language.isBlank() || !language.equalsIgnoreCase("English") && !language.equalsIgnoreCase("deutsch")) {
                return 1;
            }
            switch (language.toLowerCase()) {
                case "englisch": {
                    MessageHelper.setPlayerLanguage(executor, MessageHelper.Language.ENGLISH);
                    executor.sendRichMessage("<dark_green>Your language was changed to Englisch!");
                    break;
                }
                case "deutsch": {
                    MessageHelper.setPlayerLanguage(executor, MessageHelper.Language.GERMAN);
                    executor.sendRichMessage("<dark_green>Deine Sprache wurde auf Deutsch ge\u00e4ndert!");
                }
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"viewRecipe").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "advancedbeacons.command.viewrecipe"))).then(Commands.argument((String)"Tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).suggests((context, builder) -> {
            builder.suggest(1);
            builder.suggest(2);
            builder.suggest(3);
            builder.suggest(4);
            builder.suggest(5);
            return builder.buildFuture();
        }).executes(context -> {
            Player executor = this.getExecutingPlayer((CommandContext<CommandSourceStack>)context);
            int tier = IntegerArgumentType.getInteger((CommandContext)context, (String)"Tier");
            if (tier < 1 || tier > 5) {
                executor.sendRichMessage("<red>No tier found!");
                return 1;
            }
            TBRecipe tbRecipe = TBRecipeHelper.getRecipeByName("beacon_tier_" + tier);
            tbRecipe.show(executor);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"giveBeacon").requires(source -> this.isPlayerPerm((CommandSourceStack)source, "advancedbeacons.command.givebeacon"))).then(Commands.argument((String)"Tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).suggests((context, builder) -> {
            builder.suggest(1);
            builder.suggest(2);
            builder.suggest(3);
            builder.suggest(4);
            builder.suggest(5);
            return builder.buildFuture();
        }).executes(context -> {
            Player executor = this.getExecutingPlayer((CommandContext<CommandSourceStack>)context);
            int tier = IntegerArgumentType.getInteger((CommandContext)context, (String)"Tier");
            if (tier < 1 || tier > 5) {
                executor.sendRichMessage("<red>No tier found!");
                return 1;
            }
            InventoryUtils.giveItemOrDrop(executor.getInventory(), BeaconManager.getBeaconItem(tier));
            return 1;
        })));
        return nodeBuilder.build();
    }
}

