/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.advancedBeacons.Beacon;

import de.tim2byte.advancedBeacons.Beacon.AdvancedBeacon;
import de.tim2byte.advancedBeacons.Beacon.BeaconManager;
import de.tim2byte.advancedBeacons.Util.Configs;
import de.tim2byte.advancedBeacons.Util.Messages;
import de.tim2byte.tBLib.GUI.TBCustomGUI;
import de.tim2byte.tBLib.item.ItemBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BeaconGUI
extends TBCustomGUI {
    private final AdvancedBeacon beacon;

    public BeaconGUI(Player player, AdvancedBeacon beacon, String page) {
        super(player, page, 54, beacon.getName(), Material.PURPLE_STAINED_GLASS_PANE, Material.MAGENTA_STAINED_GLASS_PANE);
        this.beacon = beacon;
        this.inventory.setItem(13, new ItemBuilder(BeaconManager.getBeaconItem(beacon.getTier()).clone()).addLore(Messages.GUI_BEACON_RANGE.getMessage(player).replace("%range%", "" + AdvancedBeacon.getRange(beacon.getTier()))).build());
        this.clickable(28, this.getPotionItem(AdvancedBeacon.Effect.SPEED), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.SPEED));
        this.clickable(29, this.getPotionItem(AdvancedBeacon.Effect.HASTE), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.HASTE));
        this.clickable(30, this.getPotionItem(AdvancedBeacon.Effect.JUMP_BOOST), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.JUMP_BOOST));
        this.clickable(32, this.getPotionItem(AdvancedBeacon.Effect.RESISTANCE), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.RESISTANCE));
        this.clickable(33, this.getPotionItem(AdvancedBeacon.Effect.STRENGTH), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.STRENGTH));
        this.clickable(34, this.getPotionItem(AdvancedBeacon.Effect.REGENERATION), (i, h) -> this.changeLevel(AdvancedBeacon.Effect.REGENERATION));
        if (!Configs.CONFIG.getOrSetDefault("base.onlyVanillaEffects", false).booleanValue()) {
            this.clickable(37, this.getPotionItem(AdvancedBeacon.Effect.GLOWING), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.GLOWING));
            this.clickable(38, this.getPotionItem(AdvancedBeacon.Effect.NIGHT_VISION), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.NIGHT_VISION));
            this.clickable(39, this.getPotionItem(AdvancedBeacon.Effect.SLOW_FALLING), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.SLOW_FALLING));
            this.clickable(41, this.getPotionItem(AdvancedBeacon.Effect.FIRE_RESISTANCE), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.FIRE_RESISTANCE));
            this.clickable(42, this.getPotionItem(AdvancedBeacon.Effect.LUCK), (i, k) -> this.changeLevel(AdvancedBeacon.Effect.LUCK));
            this.clickable(43, this.getPotionItem(AdvancedBeacon.Effect.HEALTH_BOOST), (i, h) -> this.changeLevel(AdvancedBeacon.Effect.HEALTH_BOOST));
        }
    }

    private ItemStack getPotionItem(AdvancedBeacon.Effect effect) {
        String name = switch (effect) {
            default -> throw new MatchException(null, null);
            case AdvancedBeacon.Effect.SPEED -> Messages.GUI_EFFECT_SPEED.getMessage(this.player);
            case AdvancedBeacon.Effect.HASTE -> Messages.GUI_EFFECT_HASTE.getMessage(this.player);
            case AdvancedBeacon.Effect.JUMP_BOOST -> Messages.GUI_EFFECT_JUMP_BOOST.getMessage(this.player);
            case AdvancedBeacon.Effect.RESISTANCE -> Messages.GUI_EFFECT_RESISTANCE.getMessage(this.player);
            case AdvancedBeacon.Effect.STRENGTH -> Messages.GUI_EFFECT_STRENGTH.getMessage(this.player);
            case AdvancedBeacon.Effect.REGENERATION -> Messages.GUI_EFFECT_REGENERATION.getMessage(this.player);
            case AdvancedBeacon.Effect.GLOWING -> Messages.GUI_EFFECT_GLOWING.getMessage(this.player);
            case AdvancedBeacon.Effect.NIGHT_VISION -> Messages.GUI_EFFECT_NIGHT_VISION.getMessage(this.player);
            case AdvancedBeacon.Effect.SLOW_FALLING -> Messages.GUI_EFFECT_SLOW_FALLING.getMessage(this.player);
            case AdvancedBeacon.Effect.FIRE_RESISTANCE -> Messages.GUI_EFFECT_FIRE_RESISTANCE.getMessage(this.player);
            case AdvancedBeacon.Effect.LUCK -> Messages.GUI_EFFECT_LUCK.getMessage(this.player);
            case AdvancedBeacon.Effect.HEALTH_BOOST -> Messages.GUI_EFFECT_HEALTH_BOOST.getMessage(this.player);
        };
        ArrayList<CallSite> levelLore = new ArrayList<CallSite>();
        for (int level = 1; level <= effect.maxLevel(); ++level) {
            int requiredTier = effect.requiredTier(level);
            if (requiredTier > this.beacon.getTier()) {
                levelLore.add((CallSite)((Object)("<red> -> " + level + " " + Messages.GUI_EFFECT_LOCKED.getMessage(this.player).replace("%tier%", "Tier " + requiredTier))));
                continue;
            }
            if (this.beacon.getActiveEffectLevel(effect) == level) {
                levelLore.add((CallSite)((Object)("<green><b>  -> " + level + " " + Messages.GUI_EFFECT_SELECTED.getMessage(this.player))));
                continue;
            }
            levelLore.add((CallSite)((Object)("<gray> -> " + level)));
        }
        return new ItemBuilder(Material.POTION).setPotionColor(effect.getColor()).setName(name).hide().addLoreIf(this.beacon.isEffectActive(effect), Messages.GUI_STATUS_ACTIVATED.getMessage(this.player)).addLoreIf(!this.beacon.isEffectActive(effect), Messages.GUI_STATUS_DEACTIVATED.getMessage(this.player)).addLore(" ", "<gray>Level", levelLore).build();
    }

    private void changeLevel(AdvancedBeacon.Effect effect) {
        int currentLevel = this.beacon.isEffectActive(effect) ? this.beacon.getActiveEffectLevel(effect) : 0;
        int newLevel = currentLevel + 1;
        if (currentLevel == effect.maxLevel() || !effect.isUnlocked(this.beacon.getTier(), newLevel)) {
            this.beacon.deactivateEffect(effect);
            this.player.openInventory(this.getNewInstance(this.page).getInventory());
        } else {
            this.beacon.activateEffect(effect, newLevel);
            this.player.openInventory(this.getNewInstance(this.page).getInventory());
        }
    }

    @Override
    public TBCustomGUI getNewInstance(String page) {
        return new BeaconGUI(this.player, this.beacon, page);
    }
}

