/*
 * Decompiled with CFR 0.152.
 */
package de.tim2byte.advancedBeacons.Beacon;

import de.tim2byte.advancedBeacons.Beacon.BeaconManager;
import de.tim2byte.advancedBeacons.Util.Configs;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedBeacon {
    private final int tier;
    private final Beacon beacon;
    private final String worldName;
    private final int minX;
    private final int maxX;
    private final EnumMap<Effect, Integer> activatedEffects;
    public static final HashMap<String, AdvancedBeacon> beaconMap = new HashMap();

    private AdvancedBeacon(int tier, Beacon beacon, @Nullable EnumMap<Effect, Integer> activatedEffects) {
        this.tier = tier;
        this.beacon = beacon;
        this.worldName = beacon.getWorld().getName();
        int range = AdvancedBeacon.getRange(tier);
        this.minX = beacon.getX() - range;
        this.maxX = beacon.getX() + range;
        this.activatedEffects = activatedEffects == null ? new EnumMap(Effect.class) : activatedEffects;
    }

    @NotNull
    public static AdvancedBeacon getAdvancedBeacon(Beacon beacon) {
        String key = beacon.getWorld().getName() + ";" + beacon.getX() + ";" + beacon.getY() + ";" + beacon.getZ();
        if (beaconMap.containsKey(key)) {
            return beaconMap.get(key);
        }
        PersistentDataContainer container = beacon.getPersistentDataContainer();
        if (!container.has(BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER)) {
            throw new RuntimeException("Beacon is not an Advanced Beacon!");
        }
        int tier = (Integer)container.getOrDefault(BeaconManager.BEACON_TIER_KEY, PersistentDataType.INTEGER, (Object)-1);
        if (tier < 1 || tier > 5) {
            throw new RuntimeException("AdvancedBeacon tier is invalid! " + tier);
        }
        AdvancedBeacon advancedBeacon = new AdvancedBeacon(tier, beacon, null);
        beaconMap.put(key, advancedBeacon);
        return advancedBeacon;
    }

    public void work() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equals(this.worldName) || player.getX() > (double)this.maxX || player.getX() < (double)this.minX) continue;
            this.activatedEffects.forEach((effect, level) -> player.addPotionEffect(new PotionEffect(effect.type, 400, level - 1)));
        }
    }

    public void unregister() {
        this.activatedEffects.clear();
        String key = this.beacon.getWorld().getName() + ";" + this.beacon.getX() + ";" + this.beacon.getY() + ";" + this.beacon.getZ();
        beaconMap.remove(key);
    }

    public static void loadAll() {
        ConfigurationSection dataSection = Configs.BEACON_DATA.getConfigurationSection("data");
        if (dataSection == null) {
            return;
        }
        dataSection.getKeys(false).forEach(key -> {
            Beacon minecraftBeacon;
            int tier = Configs.BEACON_DATA.getOrDefault("data." + key + ".tier", 0);
            if (tier < 1 || tier > 5) {
                throw new RuntimeException("Cannot load beacon: tier is invalid: " + tier);
            }
            EnumMap<Effect, Integer> effects = new EnumMap<Effect, Integer>(Effect.class);
            ConfigurationSection section = Configs.BEACON_DATA.getConfigurationSection("data." + key + ".activeEffects");
            if (section != null) {
                for (String effectName : section.getKeys(false)) {
                    Effect effect = Effect.valueOf(effectName);
                    int level = section.getInt(effectName);
                    effects.put(effect, level);
                }
            }
            try {
                Object[] parts = key.split(";");
                World world = Bukkit.getWorld((String)parts[0]);
                int x = Integer.parseInt(parts[1]);
                int y = Integer.parseInt(parts[2]);
                int z = Integer.parseInt(parts[3]);
                if (world == null) {
                    throw new RuntimeException("Could not load Beacon because word is null! World: " + Arrays.toString(parts));
                }
                Block block = world.getBlockAt(x, y, z);
                if (!block.getType().equals((Object)Material.BEACON)) {
                    throw new RuntimeException("No beacon at the location! " + Arrays.toString(parts));
                }
                minecraftBeacon = (Beacon)block.getState();
            }
            catch (Exception e) {
                Configs.BEACON_DATA.set("data." + key, null);
                throw new RuntimeException(e);
            }
            beaconMap.put((String)key, new AdvancedBeacon(tier, minecraftBeacon, effects));
        });
    }

    public static void saveAll() {
        Configs.BEACON_DATA.clearFile();
        beaconMap.forEach((key, advancedBeacon) -> {
            Configs.BEACON_DATA.set("data." + key + ".tier", advancedBeacon.getTier());
            if (!advancedBeacon.activatedEffects.isEmpty()) {
                advancedBeacon.activatedEffects.forEach((effect, level) -> Configs.BEACON_DATA.set("data." + key + ".activeEffects." + effect.name(), level));
            }
        });
    }

    public String getName() {
        return switch (this.tier) {
            case 1 -> "<b><gradient:dark_purple:light_purple>Advanced Beacon</gradient> <aqua>Tier 1";
            case 2 -> "<b><gradient:dark_purple:light_purple>Advanced Beacon</gradient> <blue>Tier 2";
            case 3 -> "<b><gradient:dark_purple:light_purple>Advanced Beacon</gradient> <dark_green>Tier 3";
            case 4 -> "<b><gradient:dark_purple:light_purple>Advanced Beacon</gradient> <red>Tier 4";
            case 5 -> "<b><gradient:dark_purple:light_purple>Advanced Beacon</gradient> <gold>Tier 5";
            default -> throw new IllegalStateException("Unexpected value: " + this.tier);
        };
    }

    public void activateEffect(Effect effect, int level) {
        if (!effect.isUnlocked(this.tier, level)) {
            throw new IllegalStateException("Level " + level + " requires tier " + effect.requiredTier(level));
        }
        this.activatedEffects.put(effect, level);
    }

    public void deactivateEffect(Effect effect) {
        this.activatedEffects.remove((Object)effect);
    }

    public boolean isEffectActive(Effect effect) {
        return this.activatedEffects.containsKey((Object)effect);
    }

    public int getActiveEffectLevel(Effect effect) {
        if (!this.isEffectActive(effect)) {
            return 0;
        }
        return this.activatedEffects.get((Object)effect);
    }

    public static int getRange(int tier) {
        return switch (tier) {
            case 1 -> 60;
            case 2 -> 80;
            case 3 -> 128;
            case 4 -> 175;
            case 5 -> 256;
            default -> throw new IllegalStateException("Unexpected value: " + tier);
        };
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    @Generated
    public Beacon getBeacon() {
        return this.beacon;
    }

    @Generated
    public String getWorldName() {
        return this.worldName;
    }

    @Generated
    public int getMinX() {
        return this.minX;
    }

    @Generated
    public int getMaxX() {
        return this.maxX;
    }

    public static enum Effect {
        SPEED(PotionEffectType.SPEED, Color.AQUA, new int[]{1, 2, 3, 4, 5}),
        HASTE(PotionEffectType.HASTE, Color.ORANGE, new int[]{1, 2, 3, 4, 5}),
        JUMP_BOOST(PotionEffectType.JUMP_BOOST, Color.GREEN, new int[]{1, 2, 3, 4, 5}),
        RESISTANCE(PotionEffectType.RESISTANCE, Color.GRAY, new int[]{3, 4}),
        STRENGTH(PotionEffectType.STRENGTH, Color.YELLOW, new int[]{3, 4, 5}),
        REGENERATION(PotionEffectType.REGENERATION, Color.PURPLE, new int[]{3, 4, 5}),
        GLOWING(PotionEffectType.GLOWING, Color.YELLOW, new int[]{1}),
        NIGHT_VISION(PotionEffectType.NIGHT_VISION, Color.BLUE, new int[]{1}),
        SLOW_FALLING(PotionEffectType.SLOW_FALLING, Color.WHITE, new int[]{2, 3, 4}),
        FIRE_RESISTANCE(PotionEffectType.FIRE_RESISTANCE, Color.ORANGE, new int[]{3}),
        LUCK(PotionEffectType.LUCK, Color.GREEN, new int[]{3, 4, 5}),
        HEALTH_BOOST(PotionEffectType.HEALTH_BOOST, Color.MAROON, new int[]{4, 5});

        private final PotionEffectType type;
        private final Color color;
        private final int[] levelTiers;

        private Effect(PotionEffectType type, Color color, int[] levelTiers) {
            this.type = type;
            this.color = color;
            this.levelTiers = levelTiers;
        }

        public int maxLevel() {
            return this.levelTiers.length;
        }

        public int requiredTier(int level) {
            if (level < 1 || level > this.levelTiers.length) {
                throw new IllegalArgumentException("Invalid level " + level);
            }
            return this.levelTiers[level - 1];
        }

        public boolean isUnlocked(int beaconTier, int level) {
            return beaconTier >= this.requiredTier(level);
        }

        @Generated
        public PotionEffectType getType() {
            return this.type;
        }

        @Generated
        public Color getColor() {
            return this.color;
        }

        @Generated
        public int[] getLevelTiers() {
            return this.levelTiers;
        }
    }
}

