/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigerx6.randomizer.commands;

import io.github.tigerx6.randomizer.Randomizer;
import io.github.tigerx6.randomizer.commands.subCommands.Players;
import io.github.tigerx6.randomizer.commands.subCommands.PlayersAdd;
import io.github.tigerx6.randomizer.commands.subCommands.PlayersRemove;
import io.github.tigerx6.randomizer.commands.subCommands.Shuffle;
import io.github.tigerx6.randomizer.commands.subCommands.Start;
import io.github.tigerx6.randomizer.commands.subCommands.Stop;
import io.github.tigerx6.randomizer.listeners.BlockBreakListener;
import io.github.tigerx6.randomizer.listeners.MobDeathListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000f2\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0)H\u0016\u00a2\u0006\u0002\u0010*J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J;\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000f2\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0)H\u0016\u00a2\u0006\u0002\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00101R\u001a\u00102\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0011\"\u0004\b4\u0010\u0013\u00a8\u0006:"}, d2={"Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "Lorg/bukkit/command/TabExecutor;", "plugin", "Lio/github/tigerx6/randomizer/Randomizer;", "<init>", "(Lio/github/tigerx6/randomizer/Randomizer;)V", "mobDeathListener", "Lio/github/tigerx6/randomizer/listeners/MobDeathListener;", "getMobDeathListener", "()Lio/github/tigerx6/randomizer/listeners/MobDeathListener;", "blockBreakListener", "Lio/github/tigerx6/randomizer/listeners/BlockBreakListener;", "getBlockBreakListener", "()Lio/github/tigerx6/randomizer/listeners/BlockBreakListener;", "challengeStatus", "", "getChallengeStatus", "()Ljava/lang/String;", "setChallengeStatus", "(Ljava/lang/String;)V", "randomizerPlayers", "", "getRandomizerPlayers", "()Ljava/util/List;", "onlinePlayers", "getOnlinePlayers", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "prefix", "Lnet/kyori/adventure/text/Component;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "elapsedS", "Lkotlin/time/Duration;", "J", "timerText", "getTimerText", "setTimerText", "startTimer", "", "stopTimer", "onTabComplete", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Randomizer"})
public final class ChallengeCommand
implements TabExecutor {
    @NotNull
    private final Randomizer plugin;
    @NotNull
    private final MobDeathListener mobDeathListener;
    @NotNull
    private final BlockBreakListener blockBreakListener;
    @NotNull
    private String challengeStatus;
    @NotNull
    private final List<String> randomizerPlayers;
    @NotNull
    private final List<String> onlinePlayers;
    @NotNull
    private final FileConfiguration config;
    @NotNull
    private MiniMessage mm;
    @NotNull
    private final Component prefix;
    @NotNull
    private final ScheduledExecutorService executorService;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    private long elapsedS;
    @NotNull
    private String timerText;

    public ChallengeCommand(@NotNull Randomizer plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.mobDeathListener = this.plugin.getMobDeathListener();
        this.blockBreakListener = this.plugin.getBlockBreakListener();
        this.challengeStatus = "end";
        this.randomizerPlayers = new ArrayList();
        this.onlinePlayers = new ArrayList();
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
        this.mm = miniMessage;
        Component component = this.mm.deserialize((Object)String.valueOf(this.config.getString("plugin-messages.prefix"))).append((Component)Component.text((String)" "));
        Intrinsics.checkNotNullExpressionValue(component, "append(...)");
        this.prefix = component;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(0);
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "newScheduledThreadPool(...)");
        this.executorService = scheduledExecutorService;
        this.elapsedS = DurationKt.toDuration(0, DurationUnit.SECONDS);
        this.timerText = "";
    }

    @NotNull
    public final MobDeathListener getMobDeathListener() {
        return this.mobDeathListener;
    }

    @NotNull
    public final BlockBreakListener getBlockBreakListener() {
        return this.blockBreakListener;
    }

    @NotNull
    public final String getChallengeStatus() {
        return this.challengeStatus;
    }

    public final void setChallengeStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.challengeStatus = string;
    }

    @NotNull
    public final List<String> getRandomizerPlayers() {
        return this.randomizerPlayers;
    }

    @NotNull
    public final List<String> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        this.onlinePlayers.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.onlinePlayers.add(string);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.prefix.append(this.mm.deserialize((Object)String.valueOf(this.config.getString("plugin-messages.not-player-error")))));
            return true;
        }
        if (!(args2.length == 0)) {
            if (Intrinsics.areEqual(args2[0], "start")) {
                if (sender.hasPermission("randomizer.start")) {
                    if (args2.length == 1) {
                        if (this.randomizerPlayers.isEmpty() && this.config.getBoolean("use_player_list")) {
                            sender.sendMessage(this.prefix.append(this.mm.deserialize((Object)String.valueOf(this.config.getString("plugin-messages.empty-player-list")))));
                            return true;
                        }
                        return new Start(this.plugin).onCommand(sender, command, label, args2);
                    }
                    return ChallengeCommand.onCommand$sendArgsError(sender, this);
                }
                return ChallengeCommand.onCommand$sendPermissionError(sender, this);
            }
            if (Intrinsics.areEqual(args2[0], "stop")) {
                if (sender.hasPermission("randomizer.stop")) {
                    return args2.length == 1 ? new Stop(this.plugin).onCommand(sender, command, label, args2) : ChallengeCommand.onCommand$sendArgsError(sender, this);
                }
                ChallengeCommand.onCommand$sendPermissionError(sender, this);
            }
            if (Intrinsics.areEqual(args2[0], "shuffle")) {
                return sender.hasPermission("randomizer.shuffle") ? (args2.length <= 2 ? new Shuffle(this.plugin, this).onCommand(sender, command, label, args2) : ChallengeCommand.onCommand$sendArgsError(sender, this)) : ChallengeCommand.onCommand$sendPermissionError(sender, this);
            }
            if (Intrinsics.areEqual(args2[0], "players")) {
                if (!this.config.getBoolean("use_player_list")) {
                    sender.sendMessage(this.prefix.append(this.mm.deserialize((Object)String.valueOf(this.config.getString("plugin-messages.not-using-player-list")))));
                }
                if (args2.length == 1) {
                    return sender.hasPermission("randomizer.players") ? new Players(this.plugin).onCommand(sender, command, label, args2) : ChallengeCommand.onCommand$sendPermissionError(sender, this);
                }
                if (args2.length <= 3) {
                    if (Intrinsics.areEqual(args2[1], "add")) {
                        return sender.hasPermission("randomizer.players.add") ? new PlayersAdd(this.plugin).onCommand(sender, command, label, args2) : ChallengeCommand.onCommand$sendPermissionError(sender, this);
                    }
                    if (Intrinsics.areEqual(args2[1], "remove")) {
                        return sender.hasPermission("randomizer.players.remove") ? new PlayersRemove(this.plugin).onCommand(sender, command, label, args2) : ChallengeCommand.onCommand$sendPermissionError(sender, this);
                    }
                }
                return ChallengeCommand.onCommand$sendArgsError(sender, this);
            }
        } else {
            if (Intrinsics.areEqual(this.challengeStatus, "end") && sender.hasPermission("randomizer.randomizer")) {
                sender.sendMessage(this.prefix.append(this.mm.deserialize((Object)String.valueOf(this.config.getString("plugin-messages.status-off")))));
                return true;
            }
            if (sender.hasPermission("randomizer.randomizer")) {
                sender.sendMessage(this.prefix.append(this.mm.deserialize((Object)String.valueOf(this.config.getString("plugin-messages.status-on")))));
            }
            return true;
        }
        return ChallengeCommand.onCommand$sendArgsError(sender, this);
    }

    @NotNull
    public final String getTimerText() {
        return this.timerText;
    }

    public final void setTimerText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.timerText = string;
    }

    public final void startTimer() {
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ ChallengeCommand this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void seconds;
                void minutes;
                void hours;
                ChallengeCommand.access$setElapsedS$p(this.this$0, Duration.plus-LRDsOJo(ChallengeCommand.access$getElapsedS$p(this.this$0), DurationKt.toDuration(1, DurationUnit.SECONDS)));
                long arg0$iv = ChallengeCommand.access$getElapsedS$p(this.this$0);
                boolean bl = false;
                long l = Duration.getInWholeHours-impl(arg0$iv);
                int n = Duration.getMinutesComponent-impl(arg0$iv);
                int n2 = Duration.getSecondsComponent-impl(arg0$iv);
                Duration.getNanosecondsComponent-impl(arg0$iv);
                int n3 = n2;
                int n4 = n;
                long l2 = l;
                ChallengeCommand challengeCommand = this.this$0;
                boolean bl2 = false;
                String string = "%02d : %02d : %02d";
                Object[] objectArray = new Object[]{(long)hours, (int)minutes, (int)seconds};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                challengeCommand.setTimerText(string2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!this.this$0.getRandomizerPlayers().contains(player.getName()) && ChallengeCommand.access$getConfig$p(this.this$0).getBoolean("use_player_list")) {
                        return;
                    }
                    player.sendActionBar(ChallengeCommand.access$getMm$p(this.this$0).deserialize((Object)("<gradient:yellow:gold:1>" + this.this$0.getTimerText())).decorate(TextDecoration.BOLD));
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public final void stopTimer() {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.elapsedS = DurationKt.toDuration(0, DurationUnit.SECONDS);
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        List<Object> list;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        this.onlinePlayers.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.onlinePlayers.add(string);
        }
        List<String> addReturnList = CollectionsKt.toMutableList((Collection)this.onlinePlayers);
        List removeReturnList = CollectionsKt.toMutableList((Collection)this.randomizerPlayers);
        addReturnList.removeAll((Collection)this.randomizerPlayers);
        if (!((Collection)addReturnList).isEmpty() && !addReturnList.contains("@a")) {
            addReturnList.add("@a");
        }
        if (!((Collection)this.randomizerPlayers).isEmpty() && !removeReturnList.contains("@a")) {
            removeReturnList.add("@a");
        }
        if (args2.length == 1) {
            String[] stringArray = new String[]{"start", "stop", "shuffle", "players"};
            list = CollectionsKt.mutableListOf(stringArray);
        } else if (args2.length == 2) {
            if (Intrinsics.areEqual(args2[0], "players")) {
                String[] stringArray = new String[]{"add", "remove"};
                list = CollectionsKt.mutableListOf(stringArray);
            } else if (Intrinsics.areEqual(args2[0], "shuffle")) {
                String[] stringArray = new String[]{"mobs", "blocks"};
                list = CollectionsKt.mutableListOf(stringArray);
            } else {
                list = new ArrayList();
            }
        } else {
            list = args2.length == 3 ? (Intrinsics.areEqual(args2[1], "add") ? addReturnList : (Intrinsics.areEqual(args2[1], "remove") ? removeReturnList : (List)new ArrayList())) : (List<String>)new ArrayList();
        }
        return list;
    }

    private static final boolean onCommand$sendPermissionError(CommandSender $sender, ChallengeCommand this$0) {
        $sender.sendMessage(this$0.prefix.append(this$0.mm.deserialize((Object)String.valueOf(this$0.config.getString("plugin-messages.permission-error")))));
        return true;
    }

    private static final boolean onCommand$sendArgsError(CommandSender $sender, ChallengeCommand this$0) {
        $sender.sendMessage(this$0.prefix.append(this$0.mm.deserialize((Object)String.valueOf(this$0.config.getString("plugin-messages.argument-error")))));
        return true;
    }

    public static final /* synthetic */ void access$setElapsedS$p(ChallengeCommand $this, long l) {
        $this.elapsedS = l;
    }

    public static final /* synthetic */ long access$getElapsedS$p(ChallengeCommand $this) {
        return $this.elapsedS;
    }

    public static final /* synthetic */ FileConfiguration access$getConfig$p(ChallengeCommand $this) {
        return $this.config;
    }

    public static final /* synthetic */ MiniMessage access$getMm$p(ChallengeCommand $this) {
        return $this.mm;
    }
}

