/*
 * Decompiled with CFR 0.152.
 */
package hu.thepingu.logEvent;

import java.lang.reflect.Constructor;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class LogEvent
extends JavaPlugin
implements CommandExecutor {
    private BukkitRunnable eventTask;
    private boolean eventRunning = false;
    private int totalTime;
    private int timeRemaining;
    private int endDistance;
    private int startDistance;
    private int broadcastInterval;
    private boolean borderShrink = true;

    public void onEnable() {
        this.getCommand("logevent").setExecutor((CommandExecutor)this);
    }

    public void onDisable() {
        this.stopEvent();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String action = args[0].toLowerCase();
        if ("start".equals(action)) {
            if (this.eventRunning) {
                sender.sendMessage(ChatColor.RED + "An event is already running!");
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage(ChatColor.YELLOW + "Usage: /logevent start <minutes> [end distance] [start distance]");
                return true;
            }
            try {
                int minutes = Integer.parseInt(args[1]);
                this.borderShrink = true;
                if (args.length >= 4) {
                    this.endDistance = Integer.parseInt(args[2]);
                    this.startDistance = Integer.parseInt(args[3]);
                } else {
                    this.borderShrink = false;
                }
                World world = (World)Bukkit.getWorlds().get(0);
                if (sender instanceof Player) {
                    world = ((Player)sender).getWorld();
                }
                this.startEvent(world, minutes * 60, this.endDistance, this.startDistance);
                String startMessage = "Log event started for " + minutes + " minutes";
                startMessage = this.borderShrink ? startMessage + " with border going from " + this.startDistance + " to " + this.endDistance + "!" : startMessage + " with a static border!";
                Bukkit.broadcastMessage((String)(ChatColor.GREEN + startMessage));
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Invalid number format.");
            }
        } else if ("stop".equals(action)) {
            if (!this.eventRunning) {
                sender.sendMessage(ChatColor.RED + "No event is currently running.");
                return true;
            }
            this.stopEvent();
            sender.sendMessage(ChatColor.GREEN + "Log event stopped!");
        } else if ("help".equals(action)) {
            this.sendHelp(sender);
        } else {
            this.sendHelp(sender);
            return true;
        }
        return true;
    }

    private void startEvent(World world, int time, int endDistance, int startDistance) {
        this.eventRunning = true;
        this.totalTime = time;
        this.timeRemaining = time;
        this.endDistance = endDistance;
        this.startDistance = startDistance;
        if (this.borderShrink) {
            world.getWorldBorder().setSize((double)startDistance);
            world.getWorldBorder().setSize((double)endDistance, (long)((double)time * 0.9));
        }
        this.killAllPlayers();
        this.killAllItems(world);
        this.broadcastInterval = this.totalTime / 5;
        this.eventTask = new BukkitRunnable(){

            public void run() {
                if (LogEvent.this.timeRemaining <= 0) {
                    LogEvent.this.stopEvent();
                    return;
                }
                LogEvent.this.updateActionBar();
                if (LogEvent.this.totalTime - LogEvent.this.timeRemaining != 0 && (LogEvent.this.totalTime - LogEvent.this.timeRemaining) % LogEvent.this.broadcastInterval == 0) {
                    LogEvent.this.broadcastRemainingTime();
                }
                LogEvent.this.timeRemaining--;
            }
        };
        this.eventTask.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void killAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.setHealth(0.0);
        }
    }

    private void killAllItems(World world) {
        for (Entity entity : world.getEntities()) {
            if (!(entity instanceof Item)) continue;
            entity.remove();
        }
    }

    private void stopEvent() {
        if (this.eventTask != null) {
            this.eventTask.cancel();
        }
        if (this.eventRunning) {
            World world = (World)Bukkit.getWorlds().get(0);
            if (Bukkit.getOnlinePlayers().size() > 0) {
                world = ((Player)Bukkit.getOnlinePlayers().iterator().next()).getWorld();
            }
            world.getWorldBorder().setSize(world.getWorldBorder().getSize());
            this.countPlayerLogs();
        }
        this.eventRunning = false;
    }

    private void updateActionBar() {
        String timeLeft = this.formatTime(this.timeRemaining);
        String message = ChatColor.RED + "Time Remaining: " + timeLeft;
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendActionBar(player, message);
        }
    }

    private void sendActionBar(Player player, String message) {
        try {
            Class<?> craftPlayerClass = Class.forName("org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer");
            Object craftPlayer = craftPlayerClass.cast(player);
            Class<?> packetPlayOutChatClass = Class.forName("net.minecraft.server.v1_8_R3.PacketPlayOutChat");
            Class<?> iChatBaseComponentClass = Class.forName("net.minecraft.server.v1_8_R3.IChatBaseComponent");
            Class<?> chatComponentTextClass = Class.forName("net.minecraft.server.v1_8_R3.ChatComponentText");
            Constructor<?> textConstructor = chatComponentTextClass.getConstructor(String.class);
            Object textComponent = textConstructor.newInstance(message);
            Constructor<?> packetConstructor = packetPlayOutChatClass.getConstructor(iChatBaseComponentClass, Byte.TYPE);
            Object chatPacket = packetConstructor.newInstance(textComponent, (byte)2);
            Object entityPlayer = craftPlayerClass.getMethod("getHandle", new Class[0]).invoke(craftPlayer, new Object[0]);
            Object playerConnection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
            playerConnection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server.v1_8_R3.Packet")).invoke(playerConnection, chatPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void broadcastRemainingTime() {
        String timeLeft = this.formatTime(this.timeRemaining);
        Bukkit.broadcastMessage((String)(ChatColor.RED + "Time remaining: " + timeLeft));
    }

    private String formatTime(int seconds) {
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    private void countPlayerLogs() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            int logCount = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || !this.isLog(item.getType())) continue;
                logCount += item.getAmount();
            }
            Bukkit.broadcastMessage((String)(ChatColor.AQUA + player.getName() + " collected " + logCount + " log(s) during the event!"));
        }
    }

    private boolean isLog(Material material) {
        return material == Material.LOG || material == Material.LOG_2;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "LogEvent Plugin Help:");
        sender.sendMessage(ChatColor.YELLOW + "Author: ThePingu");
        sender.sendMessage(ChatColor.YELLOW + "Version: " + this.getDescription().getVersion());
        sender.sendMessage(ChatColor.YELLOW + "/logevent start <minutes> [end distance] [start distance] - Starts a log event.");
        sender.sendMessage(ChatColor.YELLOW + "/logevent stop - Stops a log event.");
        sender.sendMessage(ChatColor.YELLOW + "/logevent help - Displays this help message.");
    }
}

