/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.setting.ItemBrushSettings;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import net.thenextlvl.gopaint.commands.brigadier.SimpleCommand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class ImportCommand
extends SimpleCommand {
    private ImportCommand(GoPaintPlugin plugin) {
        super(plugin, "import", null);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(GoPaintPlugin plugin) {
        ImportCommand command = new ImportCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().requires(stack -> stack.getSender() instanceof Player)).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        PlayerBrushSettings settings = this.plugin.brushController().getBrushSettings(player);
        Optional<ItemBrushSettings> parsed = this.plugin.brushController().parseBrushSettings(mainHand);
        parsed.ifPresent(settings::importSettings);
        this.plugin.bundle().sendMessage((Audience)player, parsed.isPresent() ? "command.gopaint.import.success" : "command.gopaint.import.failed");
        return 1;
    }
}

