/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush.standard;

import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import net.thenextlvl.gopaint.api.math.Sphere;
import net.thenextlvl.gopaint.api.math.curve.BezierSpline;
import net.thenextlvl.gopaint.api.model.GoPaintProvider;
import net.thenextlvl.gopaint.brush.pattern.SplinePattern;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaintBrush
extends PatternBrush {
    private final Map<UUID, List<BlockVector3>> selectedPoints = new HashMap<UUID, List<BlockVector3>>();
    private final GoPaintProvider provider;

    public PaintBrush(GoPaintProvider provider) {
        super("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODBiM2E5ZGZhYmVmYmRkOTQ5YjIxN2JiZDRmYTlhNDg2YmQwYzNmMGNhYjBkMGI5ZGZhMjRjMzMyZGQzZTM0MiJ9fX0=", Key.key((String)"gopaint", (String)"paint_brush"));
        this.provider = provider;
    }

    @Override
    public Component getName(Audience audience) {
        return this.provider.bundle().component("brush.name.paint", audience);
    }

    @Override
    public Component[] getDescription(Audience audience) {
        return new Component[]{this.provider.bundle().component("brush.description.paint.1", audience), this.provider.bundle().component("brush.description.paint.2", audience)};
    }

    @Override
    public Pattern buildPattern(EditSession session, BlockVector3 position, Player player, BrushSettings settings) {
        return new SplinePattern(session, position, player, settings);
    }

    @Override
    public void build(EditSession session, BlockVector3 position, Pattern original, double size) throws MaxChangedBlocksException {
        if (!(original instanceof SplinePattern)) {
            return;
        }
        SplinePattern pattern = (SplinePattern)original;
        Player player = pattern.player();
        if (!(player instanceof BukkitPlayer)) {
            return;
        }
        BukkitPlayer bukkit = (BukkitPlayer)player;
        UUID id = pattern.player().getUniqueId();
        this.selectedPoints.computeIfAbsent(id, ignored -> new ArrayList()).add(position);
        if (!bukkit.getPlayer().isSneaking()) {
            this.provider.bundle().sendMessage((Audience)bukkit.getPlayer(), "brush.paint.point.set", Formatter.number((String)"x", (Number)position.x()), Formatter.number((String)"y", (Number)position.y()), Formatter.number((String)"z", (Number)position.z()), Formatter.number((String)"point", (Number)this.selectedPoints.get(id).size()));
            return;
        }
        if (this.selectedPoints.get(id).size() <= 1) {
            return;
        }
        List<BlockVector3> vectors = this.selectedPoints.remove(id);
        BlockVector3 first = vectors.getFirst();
        BrushSettings settings = pattern.settings();
        Sphere.getBlocksInRadius(first, size).stream().filter(vector3 -> {
            double rate = this.getRate(settings.getFalloffStrength(), size, (BlockVector3)vector3, first);
            return settings.getRandom().nextDouble() > rate;
        }).forEach(vector3 -> {
            pattern.random(settings.getRandom().nextInt(settings.getBlocks().size()));
            LinkedList<MutableBlockVector3> curve = new LinkedList<MutableBlockVector3>();
            curve.add(MutableBlockVector3.at((int)vector3.x(), (int)vector3.y(), (int)vector3.z()));
            vectors.stream().skip(1L).map(location -> MutableBlockVector3.at((int)(vector3.x() + location.x() - first.x()), (int)(vector3.y() + location.y() - first.y()), (int)(vector3.z() + location.z() - first.z()))).forEach(curve::add);
            BezierSpline spline = new BezierSpline(curve);
            double maxCount = spline.getCurveLength() * 2.5 + 1.0;
            int y = 0;
            while ((double)y <= maxCount) {
                session.setBlock(spline.getPoint((double)y / maxCount * (double)(vectors.size() - 1)), (Pattern)pattern);
                ++y;
            }
        });
    }

    private double getRate(double falloffStrength, double size, BlockVector3 vector3, BlockVector3 first) {
        double falloffFactor = (100.0 - falloffStrength) / 100.0;
        double numerator = vector3.distance(first) - size * falloffFactor;
        double denominator = size - size * falloffFactor;
        return numerator / denominator;
    }
}

