/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush.pattern;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import net.thenextlvl.gopaint.api.brush.pattern.BuildPattern;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record UnderlayPattern(EditSession session, BlockVector3 position, Player player, BrushSettings settings) implements BuildPattern
{
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        BaseBlock block = this.applyBlock(get);
        if (!this.isUnderlay(get, block)) {
            return false;
        }
        return set.setBlock(extent, this.getRandomBlockState().withProperties(block.toBlockState()));
    }

    private boolean isUnderlay(BlockVector3 position, BaseBlock block) {
        for (int i = 1; i <= this.settings().getThickness(); ++i) {
            if (!block.getMaterial().isMovementBlocker()) {
                return false;
            }
            if (position.getStateRelativeY((Extent)this.player().getWorld(), i).getMaterial().isMovementBlocker()) continue;
            return false;
        }
        return true;
    }
}

