/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.BrushRegistry;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.brush.standard.AngleBrush;
import net.thenextlvl.gopaint.brush.standard.BucketBrush;
import net.thenextlvl.gopaint.brush.standard.DiskBrush;
import net.thenextlvl.gopaint.brush.standard.FractureBrush;
import net.thenextlvl.gopaint.brush.standard.GradientBrush;
import net.thenextlvl.gopaint.brush.standard.OverlayBrush;
import net.thenextlvl.gopaint.brush.standard.PaintBrush;
import net.thenextlvl.gopaint.brush.standard.SphereBrush;
import net.thenextlvl.gopaint.brush.standard.SplatterBrush;
import net.thenextlvl.gopaint.brush.standard.SprayBrush;
import net.thenextlvl.gopaint.brush.standard.UnderlayBrush;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CraftBrushRegistry
implements BrushRegistry {
    private final List<PatternBrush> brushes = new LinkedList<PatternBrush>();

    public CraftBrushRegistry(GoPaintPlugin plugin) {
        this.registerBrush(new SphereBrush(plugin));
        this.registerBrush(new SprayBrush(plugin));
        this.registerBrush(new SplatterBrush(plugin));
        this.registerBrush(new DiskBrush(plugin));
        this.registerBrush(new BucketBrush(plugin));
        this.registerBrush(new AngleBrush(plugin));
        this.registerBrush(new OverlayBrush(plugin));
        this.registerBrush(new UnderlayBrush(plugin));
        this.registerBrush(new FractureBrush(plugin));
        this.registerBrush(new GradientBrush(plugin));
        this.registerBrush(new PaintBrush(plugin));
    }

    @Override
    public Stream<PatternBrush> getBrushes() {
        return this.brushes.stream().sorted();
    }

    @Override
    public boolean isRegistered(PatternBrush brush) {
        return this.brushes.contains(brush);
    }

    @Override
    public void registerBrush(PatternBrush brush) throws IllegalStateException {
        Preconditions.checkState((!this.isRegistered(brush) ? 1 : 0) != 0, (Object)"Brush already registered");
        this.brushes.add(brush);
    }

    @Override
    public void unregisterBrush(PatternBrush brush) throws IllegalStateException {
        if (!this.brushes.remove(brush)) {
            throw new IllegalStateException("Brush not registered");
        }
    }

    @Override
    public Optional<PatternBrush> getBrush(Key key) {
        return this.brushes.stream().filter(brush -> brush.key().equals((Object)key)).findAny();
    }
}

