/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.math.curve;

import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import net.thenextlvl.gopaint.api.math.curve.BezierSplineSegment;
import org.jetbrains.annotations.Contract;

public class BezierSpline {
    private final MutableBlockVector3[] knots;
    private final BezierSplineSegment[] segments;
    private final double curveLength;

    public BezierSpline(List<MutableBlockVector3> curve) {
        this.knots = curve.toArray(new MutableBlockVector3[0]);
        this.segments = new BezierSplineSegment[this.knots.length - 1];
        for (int segment = 0; segment < this.knots.length - 1; ++segment) {
            this.segments[segment] = new BezierSplineSegment(this.knots[segment], this.knots[segment + 1]);
        }
        this.calculateControlPoints();
        this.curveLength = this.calculateLength();
    }

    @Contract(pure=true)
    public double calculateLength() {
        double length = this.curveLength;
        for (BezierSplineSegment segment : this.segments) {
            length += segment.getCurveLength();
        }
        return length;
    }

    @Contract(pure=true)
    public BlockVector3 getPoint(double point) {
        if (point >= (double)this.segments.length) {
            return this.getPoint(this.segments.length - 1, 1.0);
        }
        return this.getPoint((int)Math.floor(point), point - Math.floor(point));
    }

    @Contract(pure=true)
    public BlockVector3 getPoint(int segmentIndex, double factor) {
        assert (segmentIndex < this.segments.length);
        assert (factor > 0.0 && factor <= 1.0);
        return this.segments[segmentIndex].getPoint(factor);
    }

    public void calculateControlPoints() {
        OptionalDouble zFlat;
        if (this.segments.length == 0) {
            return;
        }
        OptionalDouble xFlat = Arrays.stream(this.knots).allMatch(l -> l.x() == this.knots[0].x()) ? OptionalDouble.of(this.knots[0].x()) : OptionalDouble.empty();
        OptionalDouble yFlat = Arrays.stream(this.knots).allMatch(l -> l.y() == this.knots[0].y()) ? OptionalDouble.of(this.knots[0].y()) : OptionalDouble.empty();
        OptionalDouble optionalDouble = zFlat = Arrays.stream(this.knots).allMatch(l -> l.z() == this.knots[0].z()) ? OptionalDouble.of(this.knots[0].z()) : OptionalDouble.empty();
        if (this.segments.length == 1) {
            MutableBlockVector3 midpoint = new MutableBlockVector3(0, 0, 0);
            midpoint.mutX((this.segments[0].getStartPoint().x() + this.segments[0].getEndPoint().x()) / 2);
            midpoint.mutY((this.segments[0].getStartPoint().y() + this.segments[0].getEndPoint().y()) / 2);
            midpoint.mutZ((this.segments[0].getStartPoint().z() + this.segments[0].getEndPoint().z()) / 2);
            this.segments[0].setIntermediatePoint1(midpoint);
            this.segments[0].setIntermediatePoint2(new MutableBlockVector3((BlockVector3)midpoint));
        } else {
            int i;
            this.segments[0].setCoefficient1(0.0f);
            this.segments[0].setCoefficient2(2.0f);
            this.segments[0].setCoefficient3(1.0f);
            this.segments[0].getResult().mutX(this.knots[0].x() + 2 * this.knots[1].x());
            this.segments[0].getResult().mutY(this.knots[0].y() + 2 * this.knots[1].y());
            this.segments[0].getResult().mutZ(this.knots[0].z() + 2 * this.knots[1].z());
            int n = this.knots.length - 1;
            for (i = 1; i < n - 1; ++i) {
                this.segments[i].setCoefficient1(1.0f);
                this.segments[i].setCoefficient2(4.0f);
                this.segments[i].setCoefficient3(1.0f);
                this.segments[i].getResult().mutX(4 * this.knots[i].x() + 2 * this.knots[i + 1].x());
                this.segments[i].getResult().mutY(4 * this.knots[i].y() + 2 * this.knots[i + 1].y());
                this.segments[i].getResult().mutZ(4 * this.knots[i].z() + 2 * this.knots[i + 1].z());
            }
            this.segments[n - 1].setCoefficient1(2.0f);
            this.segments[n - 1].setCoefficient2(7.0f);
            this.segments[n - 1].setCoefficient3(0.0f);
            this.segments[n - 1].getResult().mutX(8 * this.knots[n - 1].x() + this.knots[n].x());
            this.segments[n - 1].getResult().mutY(8 * this.knots[n - 1].y() + this.knots[n].y());
            this.segments[n - 1].getResult().mutZ(8 * this.knots[n - 1].z() + this.knots[n].z());
            for (i = 1; i < n; ++i) {
                float m = this.segments[i].getCoefficient1() / this.segments[i - 1].getCoefficient2();
                this.segments[i].setCoefficient2(this.segments[i].getCoefficient2() - m * this.segments[i - 1].getCoefficient3());
                this.segments[i].getResult().mutX((double)((float)this.segments[i].getResult().x() - m * (float)this.segments[i - 1].getResult().x()));
                this.segments[i].getResult().mutY((double)((float)this.segments[i].getResult().y() - m * (float)this.segments[i - 1].getResult().y()));
                this.segments[i].getResult().mutZ((double)((float)this.segments[i].getResult().z() - m * (float)this.segments[i - 1].getResult().z()));
            }
            this.segments[n - 1].getIntermediatePoint1().mutX((double)((float)this.segments[n - 1].getResult().x() / this.segments[n - 1].getCoefficient2()));
            this.segments[n - 1].getIntermediatePoint1().mutY((double)((float)this.segments[n - 1].getResult().y() / this.segments[n - 1].getCoefficient2()));
            this.segments[n - 1].getIntermediatePoint1().mutZ((double)((float)this.segments[n - 1].getResult().z() / this.segments[n - 1].getCoefficient2()));
            for (i = n - 2; i >= 0; --i) {
                this.segments[i].getIntermediatePoint1().mutX((double)(((float)this.segments[i].getResult().x() - this.segments[i].getCoefficient3() * (float)this.segments[i + 1].getIntermediatePoint1().x()) / this.segments[i].getCoefficient2()));
                this.segments[i].getIntermediatePoint1().mutY((double)(((float)this.segments[i].getResult().y() - this.segments[i].getCoefficient3() * (float)this.segments[i + 1].getIntermediatePoint1().y()) / this.segments[i].getCoefficient2()));
                this.segments[i].getIntermediatePoint1().mutZ((double)(((float)this.segments[i].getResult().z() - this.segments[i].getCoefficient3() * (float)this.segments[i + 1].getIntermediatePoint1().z()) / this.segments[i].getCoefficient2()));
            }
            for (i = 0; i < n - 1; ++i) {
                this.segments[i].getIntermediatePoint2().mutX(2 * this.knots[i + 1].x() - this.segments[i + 1].getIntermediatePoint1().x());
                this.segments[i].getIntermediatePoint2().mutY(2 * this.knots[i + 1].y() - this.segments[i + 1].getIntermediatePoint1().y());
                this.segments[i].getIntermediatePoint2().mutZ(2 * this.knots[i + 1].z() - this.segments[i + 1].getIntermediatePoint1().z());
            }
            this.segments[n - 1].getIntermediatePoint2().mutX(0.5 * (double)(this.knots[n].x() + this.segments[n - 1].getIntermediatePoint1().x()));
            this.segments[n - 1].getIntermediatePoint2().mutY(0.5 * (double)(this.knots[n].y() + this.segments[n - 1].getIntermediatePoint1().y()));
            this.segments[n - 1].getIntermediatePoint2().mutZ(0.5 * (double)(this.knots[n].z() + this.segments[n - 1].getIntermediatePoint1().z()));
        }
        xFlat.ifPresent(value -> Arrays.stream(this.segments).forEach(segment -> segment.setX(value)));
        yFlat.ifPresent(value -> Arrays.stream(this.segments).forEach(segment -> segment.setY(value)));
        zFlat.ifPresent(value -> Arrays.stream(this.segments).forEach(segment -> segment.setZ(value)));
    }

    public BezierSplineSegment[] getSegments() {
        return this.segments;
    }

    public MutableBlockVector3[] getKnots() {
        return this.knots;
    }

    public double getCurveLength() {
        return this.curveLength;
    }

    public String toString() {
        return this.knots.length + " points.";
    }
}

