/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.brush.setting;

import com.fastasyncworldedit.core.function.mask.SingleBlockTypeMask;
import com.fastasyncworldedit.core.function.mask.SurfaceMask;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.mask.VisibleMask;
import net.thenextlvl.gopaint.api.model.SurfaceMode;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.jspecify.annotations.Nullable;

public interface BrushSettings {
    public Axis getAxis();

    public PatternBrush getBrush();

    public List<Material> getBlocks();

    public Material getMask();

    public boolean isMaskEnabled();

    default public Mask getMask(EditSession session) {
        Mask mask = Optional.ofNullable(session.getMask()).orElseGet(() -> new ExistingBlockMask((Extent)session.getWorld()));
        return this.isMaskEnabled() ? Optional.of(this.getMask()).map(BukkitAdapter::asBlockType).map(blockType -> new SingleBlockTypeMask((Extent)session.getWorld(), blockType)).map(single -> MaskIntersection.of((Mask[])new Mask[]{single, mask})).orElse(mask) : mask;
    }

    default public @Nullable Mask getSurfaceMask(Player player) {
        return switch (this.getSurfaceMode()) {
            default -> throw new MatchException(null, null);
            case SurfaceMode.VISIBLE -> new VisibleMask((Extent)player.getWorld(), player.getLocation().add(0.0, 1.5, 0.0));
            case SurfaceMode.EXPOSED -> new SurfaceMask((Extent)player.getWorld());
            case SurfaceMode.DISABLED -> null;
        };
    }

    public SurfaceMode getSurfaceMode();

    public double getAngleHeightDifference();

    public int getAngleDistance();

    public int getChance();

    public int getFalloffStrength();

    public int getFractureStrength();

    public int getMixingStrength();

    public int getBrushSize();

    public int getThickness();

    public Random getRandom();
}

