/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.brush.mask;

import com.fastasyncworldedit.core.math.MutableVector3;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;

public record VisibleMask(Extent extent, Vector3 viewPoint) implements Mask
{
    public boolean test(BlockVector3 vector) {
        MutableVector3 location = new MutableVector3((float)vector.x(), (float)vector.y(), (float)vector.z());
        double distanceX = this.viewPoint().x() - location.x();
        double distanceY = this.viewPoint().y() - location.y();
        double distanceZ = this.viewPoint().z() - location.z();
        location.setComponents(location.x() + (distanceX > 1.0 ? 1.0 : (distanceX > 0.0 ? 0.5 : 0.0)), location.y() + (distanceY > 1.0 ? 1.0 : (distanceY > 0.0 ? 0.5 : 0.0)), location.z() + (distanceZ > 1.0 ? 1.0 : (distanceZ > 0.0 ? 0.5 : 0.0)));
        double distance = location.distance(this.viewPoint());
        int x = 1;
        while ((double)x < distance) {
            double moveX = distanceX * ((double)x / distance);
            double moveY = distanceY * ((double)x / distance);
            double moveZ = distanceZ * ((double)x / distance);
            BlockVector3 point = location.add(moveX, moveY, moveZ).toBlockPoint();
            if (!this.extent().getBlock(point).getMaterial().isAir()) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public Mask copy() {
        return new VisibleMask(this.extent(), this.viewPoint());
    }
}

