/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.brush;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import org.jspecify.annotations.NonNull;

public abstract class PatternBrush
implements Comparable<PatternBrush>,
Keyed,
Brush {
    private final String headValue;
    private final Key key;

    public PatternBrush(String headValue, Key key) {
        this.headValue = headValue;
        this.key = key;
    }

    public abstract Component getName(Audience var1);

    public abstract Component[] getDescription(Audience var1);

    public abstract Pattern buildPattern(EditSession var1, BlockVector3 var2, Player var3, BrushSettings var4);

    public abstract void build(EditSession var1, BlockVector3 var2, Pattern var3, double var4) throws MaxChangedBlocksException;

    public String getHeadValue() {
        return this.headValue;
    }

    public Key key() {
        return this.key;
    }

    @Override
    public int compareTo(@NonNull PatternBrush brush) {
        return this.key().compareTo(brush.key());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternBrush that = (PatternBrush)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public String toString() {
        return "PatternBrush{key=" + String.valueOf(this.key) + "}";
    }
}

