/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint;

import com.google.gson.GsonBuilder;
import core.file.FileIO;
import core.file.formats.GsonFile;
import dev.faststats.bukkit.BukkitMetrics;
import dev.faststats.core.ErrorTracker;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.thenextlvl.gopaint.adapters.KeyAdapter;
import net.thenextlvl.gopaint.adapters.MaterialAdapter;
import net.thenextlvl.gopaint.api.brush.BrushController;
import net.thenextlvl.gopaint.api.brush.BrushRegistry;
import net.thenextlvl.gopaint.api.model.GoPaintProvider;
import net.thenextlvl.gopaint.api.model.PluginConfig;
import net.thenextlvl.gopaint.api.model.SurfaceMode;
import net.thenextlvl.gopaint.brush.CraftBrushController;
import net.thenextlvl.gopaint.brush.CraftBrushRegistry;
import net.thenextlvl.gopaint.commands.GoPaintCommand;
import net.thenextlvl.gopaint.listeners.ConnectListener;
import net.thenextlvl.gopaint.listeners.InteractListener;
import net.thenextlvl.gopaint.listeners.InventoryListener;
import net.thenextlvl.gopaint.metrics.bukkit.Metrics;
import net.thenextlvl.gopaint.version.VersionChecker;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GoPaintPlugin
extends JavaPlugin
implements GoPaintProvider {
    private final Key key = Key.key((String)"gopaint_advanced", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("gopaint.properties", Locale.US).resource("gopaint_german.properties", Locale.GERMANY).build();
    private final BrushController brushController = new CraftBrushController(this);
    private final BrushRegistry brushRegistry = new CraftBrushRegistry(this);
    private final FileIO<PluginConfig> configFile = new GsonFile<PluginConfig>(this.getDataPath().resolve("config.json"), new PluginConfig(new PluginConfig.BrushConfig(Material.FEATHER, Key.key((String)"gopaint", (String)"sphere_brush"), 100, 10, 50, Axis.Y, 50, 50, Set.of("disabled"), true, Material.SPONGE, true, SurfaceMode.EXPOSED, List.of(Material.STONE)), new PluginConfig.ThicknessConfig(1, 5), new PluginConfig.AngleConfig(2, 5, 10.0, 40.0, 85.0), new PluginConfig.FractureConfig(2, 5)), new GsonBuilder().registerTypeAdapter(Material.class, (Object)new MaterialAdapter()).registerTypeAdapter(Key.class, (Object)new KeyAdapter()).setPrettyPrinting().create()).validate().save(new FileAttribute[0]);
    private final VersionChecker versionChecker = new VersionChecker(this);
    private final Metrics metrics = new Metrics(this, 22279);
    private final dev.faststats.core.Metrics fastStats = BukkitMetrics.factory().errorTracker(ErrorTracker.contextAware()).token("52cb9873b3b03df680419446780c101c").create(this);

    public GoPaintPlugin() {
        this.registerServices();
    }

    public void onLoad() {
        this.versionChecker.checkVersion();
        this.warnTranslationChanges();
    }

    private void warnTranslationChanges() {
        if (!Files.isRegularFile(this.translations.resolve("messages.properties"), new LinkOption[0]) && !Files.isRegularFile(this.translations.resolve("messages_german.properties"), new LinkOption[0])) {
            return;
        }
        this.getComponentLogger().warn("The translations for goPaintAdvanced had major backwards incompatible changes");
        this.getComponentLogger().warn("For this reason the 'messages' files got renamed to 'gopaint'");
        this.getComponentLogger().warn("If you made changes to your translations before, you have to do them again in the new 'gopaint' files");
        this.getComponentLogger().warn("This message will go away once you have deleted the old 'messages' files from '{}'", (Object)this.translations);
    }

    public void onEnable() {
        this.registerListeners();
        this.registerCommands();
    }

    public void onDisable() {
        this.fastStats.shutdown();
        this.metrics.shutdown();
    }

    public void reloadConfig() {
        this.configFile.reload();
    }

    private void registerServices() {
        this.getServer().getServicesManager().register(BrushController.class, (Object)this.brushController(), (Plugin)this, ServicePriority.Highest);
        this.getServer().getServicesManager().register(BrushRegistry.class, (Object)this.brushRegistry(), (Plugin)this, ServicePriority.Highest);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectListener(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(GoPaintCommand.create(this), List.of("gp"))));
    }

    @Override
    public PluginConfig config() {
        return this.configFile.getRoot();
    }

    @Override
    public ComponentBundle bundle() {
        return this.bundle;
    }

    @Override
    public BrushController brushController() {
        return this.brushController;
    }

    @Override
    public BrushRegistry brushRegistry() {
        return this.brushRegistry;
    }
}

