/*
 * Decompiled with CFR 0.152.
 */
package core.paper.brigadier.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import core.paper.brigadier.exceptions.ComponentCommandExceptionType;
import core.paper.cache.PlayerCache;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.Contract;

public final class OfflinePlayerArgumentType
implements CustomArgumentType<OfflinePlayer, String> {
    private static final ComponentCommandExceptionType NO_PLAYER_FOUND = new ComponentCommandExceptionType((Component)Component.translatable((String)"argument.entity.notfound.player"));

    private OfflinePlayerArgumentType() {
    }

    @Contract(value=" -> new", pure=true)
    public static OfflinePlayerArgumentType player() {
        return new OfflinePlayerArgumentType();
    }

    public OfflinePlayer parse(StringReader reader) throws CommandSyntaxException {
        String name = (String)this.getNativeType().parse(reader);
        OfflinePlayer player = Bukkit.getOfflinePlayerIfCached((String)name);
        if (player != null) {
            return player;
        }
        throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return CompletableFuture.supplyAsync(() -> {
            try (Stream<String> players = PlayerCache.getOfflinePlayers().map(OfflinePlayer::getName).filter(Objects::nonNull).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).limit(100L);){
                players.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.build();
        });
    }
}

