/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.menus;

import core.paper.gui.AbstractGUI;
import core.paper.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import net.thenextlvl.gopaint.api.model.SurfaceMode;
import net.thenextlvl.gopaint.brush.standard.AngleBrush;
import net.thenextlvl.gopaint.brush.standard.DiskBrush;
import net.thenextlvl.gopaint.brush.standard.FractureBrush;
import net.thenextlvl.gopaint.brush.standard.GradientBrush;
import net.thenextlvl.gopaint.brush.standard.OverlayBrush;
import net.thenextlvl.gopaint.brush.standard.PaintBrush;
import net.thenextlvl.gopaint.brush.standard.SplatterBrush;
import net.thenextlvl.gopaint.brush.standard.SprayBrush;
import net.thenextlvl.gopaint.brush.standard.UnderlayBrush;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class MainMenu
extends AbstractGUI {
    private final PlayerBrushSettings settings;
    private final GoPaintPlugin plugin;
    private final Inventory inventory;

    public MainMenu(GoPaintPlugin plugin, PlayerBrushSettings settings, Player owner) {
        super(owner, plugin.bundle().component("menu.main.title", (Audience)owner));
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, this.title());
        this.settings = settings;
        this.plugin = plugin;
        this.formatDefault();
        this.updateToggle();
        this.updateBrush();
        this.updateSize();
        this.updateMaskToggle();
        this.updateSurfaceMode();
        this.updateBlockPalette();
        this.updateMask();
    }

    public void updateBrush() {
        this.resetSettingSlots();
        this.updateBrushSelection();
        this.updateChance();
        this.updateAxis();
        this.updateThickness();
        this.updateAngleSettings();
        this.updateFractureSettings();
        this.updateMixingStrength();
        this.updateFalloffStrength();
    }

    private void resetSettingSlots() {
        ItemStack placeholder = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip().item();
        IntStream.of(3, 4, 12, 13, 21, 22).forEach(value -> this.inventory.setItem(value, placeholder));
    }

    public void updateMask() {
        this.inventory.setItem(52, ItemBuilder.of(this.settings.getMask()).itemName(this.plugin.bundle().component("mask.block", (Audience)this.owner)).lore(new Component[]{Component.empty(), this.plugin.bundle().component("mask.block.description", (Audience)this.owner)}).item());
    }

    public void updateBlockPalette() {
        ItemStack placeholder = ItemBuilder.of(Material.BARRIER).itemName(this.plugin.bundle().component("slot.empty", (Audience)this.owner)).lore(new Component[]{Component.empty(), this.plugin.bundle().component("slot.empty.description", (Audience)this.owner)}).item();
        IntStream.rangeClosed(46, 50).filter(value -> this.settings.getBlocks().size() <= value - 46).forEach(value -> this.inventory.setItem(value, placeholder));
        if (this.settings.getBlocks().isEmpty()) {
            return;
        }
        double chance = 100.0 / (double)this.settings.getBlocks().size();
        for (int i = 0; i < this.settings.getBlocks().size(); ++i) {
            this.inventory.setItem(i + 46, ItemBuilder.of(this.settings.getBlocks().get(i)).amount(chance > 64.0 ? 1 : (int)chance).itemName(this.plugin.bundle().component("slot.set", (Audience)this.owner, Formatter.number((String)"slot", (Number)(i + 1)), Formatter.number((String)"chance", (Number)chance))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("slot.set.description.left", (Audience)this.owner), this.plugin.bundle().component("slot.set.description.right", (Audience)this.owner)}).item());
        }
    }

    public void updateSize() {
        this.inventory.setItem(14, ItemBuilder.of(Material.BROWN_MUSHROOM).itemName(this.plugin.bundle().component("brush.size", (Audience)this.owner, Formatter.number((String)"size", (Number)this.settings.getBrushSize()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.size.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.size.description.right", (Audience)this.owner), this.plugin.bundle().component("brush.size.description.shift", (Audience)this.owner)}).item());
    }

    public void updateFalloffStrength() {
        if (!(this.settings.getBrush() instanceof SplatterBrush || this.settings.getBrush() instanceof PaintBrush || this.settings.getBrush() instanceof GradientBrush)) {
            return;
        }
        this.inventory.setItem(12, ItemBuilder.of(Material.BLAZE_POWDER).itemName(this.plugin.bundle().component("brush.falloff", (Audience)this.owner, Formatter.number((String)"strength", (Number)this.settings.getFalloffStrength()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.falloff.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.falloff.description.right", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(3, placeholder);
        this.inventory.setItem(21, placeholder);
    }

    public void updateMixingStrength() {
        if (!(this.settings.getBrush() instanceof GradientBrush)) {
            return;
        }
        this.inventory.setItem(13, ItemBuilder.of(Material.MAGMA_CREAM).itemName(this.plugin.bundle().component("brush.mixing", (Audience)this.owner, Formatter.number((String)"strength", (Number)this.settings.getMixingStrength()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.mixing.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.mixing.description.right", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(4, placeholder);
        this.inventory.setItem(22, placeholder);
    }

    public void updateFractureSettings() {
        if (!(this.settings.getBrush() instanceof FractureBrush)) {
            return;
        }
        this.inventory.setItem(12, ItemBuilder.of(Material.DAYLIGHT_DETECTOR).itemName(this.plugin.bundle().component("brush.fracture", (Audience)this.owner, Formatter.number((String)"distance", (Number)this.settings.getFractureStrength()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.fracture.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.fracture.description.right", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(3, placeholder);
        this.inventory.setItem(21, placeholder);
    }

    public void updateAngleSettings() {
        if (!(this.settings.getBrush() instanceof AngleBrush)) {
            return;
        }
        this.inventory.setItem(12, ItemBuilder.of(Material.DAYLIGHT_DETECTOR).itemName(this.plugin.bundle().component("brush.angle.distance", (Audience)this.owner, Formatter.number((String)"distance", (Number)this.settings.getAngleDistance()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.angle.distance.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.angle.distance.description.right", (Audience)this.owner)}).item());
        this.inventory.setItem(13, ItemBuilder.of(Material.BLAZE_ROD).itemName(this.plugin.bundle().component("brush.angle.maximum", (Audience)this.owner, Formatter.number((String)"angle", (Number)this.settings.getAngleHeightDifference()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.angle.maximum.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.angle.maximum.description.right", (Audience)this.owner), this.plugin.bundle().component("brush.angle.maximum.description.shift", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(3, placeholder);
        this.inventory.setItem(4, placeholder);
        this.inventory.setItem(22, placeholder);
        this.inventory.setItem(21, placeholder);
    }

    public void updateThickness() {
        if (!(this.settings.getBrush() instanceof OverlayBrush) && !(this.settings.getBrush() instanceof UnderlayBrush)) {
            return;
        }
        this.inventory.setItem(12, ItemBuilder.of(Material.BOOK).itemName(this.plugin.bundle().component("brush.thickness", (Audience)this.owner, Formatter.number((String)"thickness", (Number)this.settings.getThickness()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.thickness.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.thickness.description.right", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(3, placeholder);
        this.inventory.setItem(21, placeholder);
    }

    public void updateAxis() {
        if (!(this.settings.getBrush() instanceof DiskBrush)) {
            return;
        }
        this.inventory.setItem(12, ItemBuilder.of(Material.COMPASS).itemName(this.plugin.bundle().component("brush.axis", (Audience)this.owner, new TagResolver[]{Placeholder.parsed((String)"axis", (String)this.settings.getAxis().name())})).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.axis.description", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(3, placeholder);
        this.inventory.setItem(21, placeholder);
    }

    public void updateChance() {
        if (!(this.settings.getBrush() instanceof SprayBrush)) {
            return;
        }
        this.inventory.setItem(12, ItemBuilder.of(Material.GOLD_NUGGET).itemName(this.plugin.bundle().component("brush.chance", (Audience)this.owner, Formatter.number((String)"chance", (Number)this.settings.getChance()))).lore(new Component[]{Component.empty(), this.plugin.bundle().component("brush.chance.description.left", (Audience)this.owner), this.plugin.bundle().component("brush.chance.description.right", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(3, placeholder);
        this.inventory.setItem(21, placeholder);
    }

    public void updateBrushSelection() {
        PatternBrush brush = this.settings.getBrush();
        ArrayList<Component> lore = new ArrayList<Component>(Arrays.asList(Component.empty(), this.plugin.bundle().component("brush.selection.description.1", (Audience)this.owner), this.plugin.bundle().component("brush.selection.description.2", (Audience)this.owner), Component.empty()));
        this.plugin.brushRegistry().getBrushes().map(current -> {
            NamedTextColor color = current.equals(brush) ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY;
            return current.getName((Audience)this.owner).decoration(TextDecoration.ITALIC, false).color((TextColor)color);
        }).forEach(lore::addLast);
        this.inventory.setItem(11, ItemBuilder.of(Material.PLAYER_HEAD).profileValue(brush.getHeadValue()).itemName(this.plugin.bundle().component("brush.selection", (Audience)this.owner)).lore(lore).item());
    }

    public void updateToggle() {
        this.inventory.setItem(10, ItemBuilder.of(this.plugin.config().brushConfig().defaultBrushType()).itemName(this.plugin.bundle().component("brush.toggle", (Audience)this.owner)).lore(new Component[]{this.plugin.bundle().component(this.settings.isEnabled() ? "brush.state.enabled" : "brush.state.disabled", (Audience)this.owner), Component.empty(), this.plugin.bundle().component("brush.toggle.description.1", (Audience)this.owner), this.plugin.bundle().component("brush.toggle.description.2", (Audience)this.owner), this.plugin.bundle().component("brush.toggle.description.3", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(this.settings.isEnabled() ? Material.LIME_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(1, placeholder);
        this.inventory.setItem(19, placeholder);
    }

    public void updateMaskToggle() {
        Material icon = this.settings.isMaskEnabled() ? Material.JACK_O_LANTERN : Material.CARVED_PUMPKIN;
        this.inventory.setItem(15, ItemBuilder.of(icon).itemName(this.plugin.bundle().component("mask.state", (Audience)this.owner)).lore(new Component[]{this.plugin.bundle().component(this.settings.isMaskEnabled() ? "mask.enabled" : "mask.disabled", (Audience)this.owner), Component.empty(), this.plugin.bundle().component("click.cycle", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(this.settings.isMaskEnabled() ? Material.LIME_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE).hideTooltip().item();
        this.inventory.setItem(6, placeholder);
        this.inventory.setItem(24, placeholder);
    }

    public void updateSurfaceMode() {
        Material icon = switch (this.settings.getSurfaceMode()) {
            default -> throw new MatchException(null, null);
            case SurfaceMode.EXPOSED -> Material.LIGHT_WEIGHTED_PRESSURE_PLATE;
            case SurfaceMode.DISABLED -> Material.POLISHED_BLACKSTONE_PRESSURE_PLATE;
            case SurfaceMode.VISIBLE -> Material.HEAVY_WEIGHTED_PRESSURE_PLATE;
        };
        this.inventory.setItem(16, ItemBuilder.of(icon).itemName(this.plugin.bundle().component("surface.mode", (Audience)this.owner)).lore(new Component[]{this.plugin.bundle().component(this.settings.getSurfaceMode().translationKey(), (Audience)this.owner), Component.empty(), this.plugin.bundle().component("surface.mode.description", (Audience)this.owner)}).item());
        ItemStack placeholder = ItemBuilder.of(switch (this.settings.getSurfaceMode()) {
            default -> throw new MatchException(null, null);
            case SurfaceMode.EXPOSED -> Material.LIME_STAINED_GLASS_PANE;
            case SurfaceMode.DISABLED -> Material.RED_STAINED_GLASS_PANE;
            case SurfaceMode.VISIBLE -> Material.ORANGE_STAINED_GLASS_PANE;
        }).hideTooltip().item();
        this.inventory.setItem(7, placeholder);
        this.inventory.setItem(25, placeholder);
    }

    private void formatDefault() {
        ItemStack grayGlassPane = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip().item();
        ItemStack yellowGlassPane = ItemBuilder.of(Material.YELLOW_STAINED_GLASS_PANE).hideTooltip().item();
        ItemStack whiteGlassPane = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip().item();
        ItemStack orangeGlassPane = ItemBuilder.of(Material.ORANGE_STAINED_GLASS_PANE).hideTooltip().item();
        IntStream.range(0, this.inventory.getSize()).forEach(value -> this.inventory.setItem(value, grayGlassPane));
        IntStream.of(43, 37, 38, 39, 40, 41).forEach(value -> this.inventory.setItem(value, yellowGlassPane));
        this.inventory.setItem(5, whiteGlassPane);
        this.inventory.setItem(23, whiteGlassPane);
        this.inventory.setItem(2, orangeGlassPane);
        this.inventory.setItem(20, orangeGlassPane);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

