/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.menus;

import core.paper.gui.PaginatedGUI;
import core.paper.item.ActionItem;
import core.paper.item.ItemBuilder;
import java.util.Collection;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import net.thenextlvl.gopaint.api.model.GoPaintProvider;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BrushesMenu
extends PaginatedGUI<GoPaintProvider, PatternBrush> {
    private final PaginatedGUI.Pagination pagination = new PaginatedGUI.Pagination(IntStream.range(0, this.getSize() - 9).toArray(), this.getSize() - 6, this.getSize() - 4);
    private final PlayerBrushSettings settings;

    public BrushesMenu(GoPaintProvider plugin, PlayerBrushSettings settings, Player owner) {
        super(plugin, owner, plugin.bundle().component("menu.brushes.title", (Audience)owner), 3);
        this.settings = settings;
        this.loadPage(0);
    }

    @Override
    protected void onClose() {
        this.owner.getScheduler().run(this.plugin, task -> this.settings.getMainMenu().open(), null);
    }

    @Override
    public void formatDefault() {
        ItemBuilder placeholder = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip();
        IntStream.range(0, this.getSize()).forEach(value -> this.setSlotIfAbsent(value, placeholder));
    }

    @Override
    public ActionItem constructItem(PatternBrush brush) {
        return ItemBuilder.of(Material.PLAYER_HEAD).profileValue(brush.getHeadValue()).itemName(brush.getName((Audience)this.owner).colorIfAbsent((TextColor)NamedTextColor.GOLD)).lore(new Component[]{Component.empty()}).appendLore(((GoPaintProvider)this.plugin).bundle().component("brush.click.select", (Audience)this.owner)).appendLore(new Component[]{Component.empty()}).appendLore(brush.getDescription((Audience)this.owner)).withAction(() -> {
            this.settings.setBrush(brush);
            this.settings.getMainMenu().open();
        });
    }

    @Override
    public Component getPageFormat(int page) {
        String key = page > this.getCurrentPage() ? "gui.page.next" : "gui.page.previous";
        return ((GoPaintProvider)this.plugin).bundle().component(key, (Audience)this.owner);
    }

    @Override
    public Collection<PatternBrush> getElements() {
        return ((GoPaintProvider)this.plugin).brushRegistry().getBrushes().toList();
    }

    @Override
    public PaginatedGUI.Pagination getPagination() {
        return this.pagination;
    }
}

