/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.listeners;

import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import net.thenextlvl.gopaint.api.model.SurfaceMode;
import net.thenextlvl.gopaint.brush.standard.AngleBrush;
import net.thenextlvl.gopaint.brush.standard.DiskBrush;
import net.thenextlvl.gopaint.brush.standard.FractureBrush;
import net.thenextlvl.gopaint.brush.standard.GradientBrush;
import net.thenextlvl.gopaint.brush.standard.OverlayBrush;
import net.thenextlvl.gopaint.brush.standard.PaintBrush;
import net.thenextlvl.gopaint.brush.standard.SplatterBrush;
import net.thenextlvl.gopaint.brush.standard.SprayBrush;
import net.thenextlvl.gopaint.brush.standard.UnderlayBrush;
import net.thenextlvl.gopaint.menus.MainMenu;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class InventoryListener
implements Listener {
    private final GoPaintPlugin plugin;

    public InventoryListener(GoPaintPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void menuClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getView().getTopInventory().getHolder(true) instanceof MainMenu)) {
            return;
        }
        if (event.getView().getTopInventory() != event.getClickedInventory()) {
            if (event.getClick().isShiftClick() || event.getAction().equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        if (event.getAction().equals((Object)InventoryAction.NOTHING)) {
            return;
        }
        PlayerBrushSettings settings = this.plugin.brushController().getBrushSettings(player);
        Material itemType = event.getCursor().getType();
        if (event.getRawSlot() == 10 || event.getRawSlot() == 1 || event.getRawSlot() == 19) {
            if (event.getCursor().isEmpty()) {
                settings.setEnabled(!settings.isEnabled());
                return;
            }
            this.plugin.brushController().parseBrushSettings(event.getCursor()).ifPresentOrElse(settings::importSettings, () -> settings.exportSettings(event.getCursor()));
        } else if (event.getRawSlot() == 11 || event.getRawSlot() == 2 || event.getRawSlot() == 20) {
            if (event.getClick().equals((Object)ClickType.LEFT)) {
                settings.setBrush(settings.getNextBrush(settings.getBrush()));
            } else if (event.getClick().equals((Object)ClickType.RIGHT)) {
                settings.setBrush(settings.getPreviousBrush(settings.getBrush()));
            } else if (event.getClick().isShiftClick()) {
                settings.getBrushesMenu().open();
            }
        } else if (event.getRawSlot() == 12 || event.getRawSlot() == 3 || event.getRawSlot() == 21) {
            PatternBrush brush = settings.getBrush();
            if (brush instanceof SprayBrush) {
                if (event.getClick().isLeftClick()) {
                    settings.setChance(settings.getChance() + 10);
                } else if (event.getClick().isRightClick()) {
                    settings.setChance(settings.getChance() - 10);
                }
            } else if (brush instanceof OverlayBrush || brush instanceof UnderlayBrush) {
                if (event.getClick().isLeftClick()) {
                    settings.setThickness(settings.getThickness() + 1);
                } else if (event.getClick().isRightClick()) {
                    settings.setThickness(settings.getThickness() - 1);
                }
            } else if (brush instanceof FractureBrush) {
                if (event.getClick().isLeftClick()) {
                    settings.setFractureStrength(settings.getFractureStrength() + 1);
                } else if (event.getClick().isRightClick()) {
                    settings.setFractureStrength(settings.getFractureStrength() - 1);
                }
            } else if (brush instanceof AngleBrush) {
                if (event.getClick().isLeftClick()) {
                    settings.setAngleDistance(settings.getAngleDistance() + 1);
                } else if (event.getClick().isRightClick()) {
                    settings.setAngleDistance(settings.getAngleDistance() - 1);
                }
            } else if (brush instanceof GradientBrush || brush instanceof PaintBrush || brush instanceof SplatterBrush) {
                if (event.getClick().isLeftClick()) {
                    settings.setFalloffStrength(settings.getFalloffStrength() + 10);
                } else if (event.getClick().isRightClick()) {
                    settings.setFalloffStrength(settings.getFalloffStrength() - 10);
                }
            } else if (brush instanceof DiskBrush) {
                settings.setAxis(switch (settings.getAxis()) {
                    default -> throw new MatchException(null, null);
                    case Axis.X -> Axis.Y;
                    case Axis.Y -> Axis.Z;
                    case Axis.Z -> Axis.X;
                });
            }
        } else if (event.getRawSlot() == 13 || event.getRawSlot() == 4 || event.getRawSlot() == 22) {
            PatternBrush brush = settings.getBrush();
            if (brush instanceof AngleBrush) {
                if (event.getClick().equals((Object)ClickType.LEFT)) {
                    settings.setAngleHeightDifference(settings.getAngleHeightDifference() + 5.0);
                } else if (event.getClick().equals((Object)ClickType.RIGHT)) {
                    settings.setAngleHeightDifference(settings.getAngleHeightDifference() - 5.0);
                } else if (event.getClick().equals((Object)ClickType.SHIFT_LEFT)) {
                    settings.setAngleHeightDifference(settings.getAngleHeightDifference() + 15.0);
                } else if (event.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                    settings.setAngleHeightDifference(settings.getAngleHeightDifference() - 15.0);
                }
            } else if (brush instanceof GradientBrush) {
                if (event.getClick().isLeftClick()) {
                    settings.setMixingStrength(settings.getMixingStrength() + 10);
                } else if (event.getClick().isRightClick()) {
                    settings.setMixingStrength(settings.getMixingStrength() - 10);
                }
            }
        } else if (event.getRawSlot() == 14 || event.getRawSlot() == 5 || event.getRawSlot() == 23) {
            if (event.getClick().equals((Object)ClickType.LEFT)) {
                settings.setBrushSize(settings.getBrushSize() + 1);
            } else if (event.getClick().equals((Object)ClickType.RIGHT)) {
                settings.setBrushSize(settings.getBrushSize() - 1);
            } else if (event.getClick().equals((Object)ClickType.SHIFT_LEFT)) {
                settings.setBrushSize(settings.getBrushSize() + 10);
            } else if (event.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                settings.setBrushSize(settings.getBrushSize() - 10);
            }
        } else if (event.getRawSlot() == 15 || event.getRawSlot() == 6 || event.getRawSlot() == 24) {
            settings.setMaskEnabled(!settings.isMaskEnabled());
        } else if (event.getRawSlot() == 16 || event.getRawSlot() == 7 || event.getRawSlot() == 25) {
            settings.setSurfaceMode(switch (settings.getSurfaceMode()) {
                default -> throw new MatchException(null, null);
                case SurfaceMode.EXPOSED -> SurfaceMode.VISIBLE;
                case SurfaceMode.VISIBLE -> SurfaceMode.DISABLED;
                case SurfaceMode.DISABLED -> SurfaceMode.EXPOSED;
            });
        } else if (event.getRawSlot() >= 37 && event.getRawSlot() <= 41 || event.getRawSlot() >= 46 && event.getRawSlot() <= 50) {
            int slot = event.getRawSlot() - (event.getRawSlot() >= 37 && event.getRawSlot() <= 41 ? 36 : 45);
            if (event.getClick().isLeftClick()) {
                if (!itemType.isSolid()) {
                    return;
                }
                settings.addBlock(itemType, slot);
            } else if (event.getClick().isRightClick()) {
                settings.removeBlock(slot);
            }
        } else if (event.getRawSlot() == 43 || event.getRawSlot() == 52) {
            if (!itemType.isSolid()) {
                return;
            }
            settings.setMask(itemType);
        }
    }
}

