/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.listeners;

import com.fastasyncworldedit.core.function.mask.AirMask;
import com.fastasyncworldedit.core.function.mask.InverseMask;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Location;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class InteractListener
implements Listener {
    private final GoPaintPlugin plugin;

    public InteractListener(GoPaintPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onClick(PlayerInteractEvent event) {
        PlayerBrushSettings playerSettings;
        PlayerBrushSettings settings;
        org.bukkit.entity.Player player = event.getPlayer();
        if (!player.hasPermission("gopaint.use")) {
            return;
        }
        if (!player.hasPermission("gopaint.world.bypass") && this.plugin.config().brushConfig().disabledWorlds().contains(player.getWorld().getName())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (event.getAction().isLeftClick() && item.getType().equals((Object)this.plugin.config().brushConfig().defaultBrushType())) {
            PlayerBrushSettings brush = this.plugin.brushController().getBrushSettings(player);
            brush.getMainMenu().open();
            event.setCancelled(true);
            return;
        }
        if (!event.getAction().isRightClick()) {
            return;
        }
        BrushSettings brushSettings = settings = !item.getType().equals((Object)this.plugin.config().brushConfig().defaultBrushType()) ? (BrushSettings)this.plugin.brushController().parseBrushSettings(item).orElse(null) : this.plugin.brushController().getBrushSettings(player);
        if (settings == null || settings.getBlocks().isEmpty()) {
            return;
        }
        if (!(settings instanceof PlayerBrushSettings) || (playerSettings = settings).isEnabled()) {
            this.handleInteract(BukkitAdapter.adapt((org.bukkit.entity.Player)player), settings);
        } else {
            this.plugin.bundle().sendMessage((Audience)player, "brush.disabled");
        }
        event.setCancelled(true);
    }

    private void handleInteract(BukkitPlayer player, BrushSettings settings) {
        player.runAsyncIfFree(() -> {
            LocalSession session = player.getSession();
            try (EditSession editSession = session.createEditSession((Actor)player);){
                Location blockTrace = player.getSolidBlockTrace(250);
                if (blockTrace == null) {
                    this.plugin.bundle().sendMessage((Audience)player.getPlayer(), "brush.block.sight");
                    editSession.cancel();
                    return;
                }
                BlockBag bag = session.getBlockBag((Player)player);
                try {
                    Request.request().setEditSession(editSession);
                    BlockVector3 position = blockTrace.toBlockPoint();
                    Mask mask = MaskIntersection.of((Mask[])new Mask[]{new InverseMask((Mask)new AirMask((Extent)player.getWorld())), settings.getMask(editSession), settings.getSurfaceMask((Player)player)});
                    Pattern pattern = settings.getBrush().buildPattern(editSession, position, (Player)player, settings);
                    editSession.setMask(mask);
                    settings.getBrush().build(editSession, position, pattern, (double)settings.getBrushSize() / 2.0);
                }
                finally {
                    if (bag != null) {
                        bag.flushChanges();
                    }
                    session.remember(editSession);
                    Request.reset();
                }
            }
        });
    }
}

