/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.commands.brigadier;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.thenextlvl.gopaint.GoPaintPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class BrigadierCommand {
    protected final GoPaintPlugin plugin;
    private final @Nullable String permission;
    private final String name;

    protected BrigadierCommand(GoPaintPlugin plugin, String name, @Nullable String permission) {
        this.plugin = plugin;
        this.permission = permission;
        this.name = name;
    }

    protected LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)Commands.literal((String)this.name).requires(this::canUse);
    }

    protected boolean canUse(CommandSourceStack source) {
        return this.permission == null || source.getSender().hasPermission(this.permission);
    }

    protected <T> Optional<T> tryGetArgument(CommandContext<CommandSourceStack> context, String name, Class<T> type) {
        try {
            return Optional.of(context.getArgument(name, type));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("No such argument '" + name + "' exists on this command")) {
                return Optional.empty();
            }
            throw e;
        }
    }
}

