/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush.standard;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import net.thenextlvl.gopaint.api.math.ConnectedBlocks;
import net.thenextlvl.gopaint.api.math.Sphere;
import net.thenextlvl.gopaint.api.model.GoPaintProvider;
import net.thenextlvl.gopaint.brush.pattern.ShufflePattern;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BucketBrush
extends PatternBrush {
    private final GoPaintProvider provider;

    public BucketBrush(GoPaintProvider provider) {
        super("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTAxOGI0NTc0OTM5Nzg4YTJhZDU1NTJiOTEyZDY3ODEwNjk4ODhjNTEyMzRhNGExM2VhZGI3ZDRjOTc5YzkzIn19fQ==", Key.key((String)"gopaint", (String)"bucket_brush"));
        this.provider = provider;
    }

    @Override
    public Component getName(Audience audience) {
        return this.provider.bundle().component("brush.name.bucket", audience);
    }

    @Override
    public Component[] getDescription(Audience audience) {
        return new Component[]{this.provider.bundle().component("brush.description.bucket.1", audience), this.provider.bundle().component("brush.description.bucket.2", audience)};
    }

    @Override
    public Pattern buildPattern(EditSession session, BlockVector3 position, Player player, BrushSettings settings) {
        return new ShufflePattern(session, position, player, settings);
    }

    @Override
    public void build(EditSession session, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        Set<BlockVector3> blocks = Sphere.getBlocksInRadius(position, size);
        ConnectedBlocks.getConnectedBlocks((Extent)session.getWorld(), position, blocks).forEach(vector3 -> session.setBlock(vector3, pattern));
    }
}

