/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush.settings;

import core.paper.gui.AbstractGUI;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.ItemBrushSettings;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import net.thenextlvl.gopaint.api.model.SurfaceMode;
import net.thenextlvl.gopaint.brush.standard.AngleBrush;
import net.thenextlvl.gopaint.brush.standard.DiskBrush;
import net.thenextlvl.gopaint.brush.standard.FractureBrush;
import net.thenextlvl.gopaint.brush.standard.GradientBrush;
import net.thenextlvl.gopaint.brush.standard.OverlayBrush;
import net.thenextlvl.gopaint.brush.standard.PaintBrush;
import net.thenextlvl.gopaint.brush.standard.SplatterBrush;
import net.thenextlvl.gopaint.brush.standard.SprayBrush;
import net.thenextlvl.gopaint.brush.standard.UnderlayBrush;
import net.thenextlvl.gopaint.menus.BrushesMenu;
import net.thenextlvl.gopaint.menus.MainMenu;
import org.bukkit.Axis;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CraftPlayerBrushSettings
implements PlayerBrushSettings {
    private static final Random random = new Random();
    private final GoPaintPlugin plugin;
    private final Player player;
    private boolean enabled;
    private int brushSize;
    private int chance;
    private int thickness;
    private int fractureStrength;
    private int angleDistance;
    private int falloffStrength;
    private int mixingStrength;
    private double angleHeightDifference;
    private Axis axis;
    private boolean maskEnabled;
    private SurfaceMode surfaceMode;
    private PatternBrush brush;
    private Material mask;
    private final List<Material> blocks = new ArrayList<Material>();
    private final MainMenu mainMenu;

    public CraftPlayerBrushSettings(GoPaintPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        Key defaultBrush = plugin.config().brushConfig().defaultBrush();
        this.brush = plugin.brushRegistry().getBrush(defaultBrush).orElseThrow(() -> new IllegalArgumentException("Unknown default brush: " + defaultBrush.asString()));
        this.surfaceMode = plugin.config().brushConfig().surfaceMode();
        this.maskEnabled = plugin.config().brushConfig().mask();
        this.enabled = plugin.config().brushConfig().enabledByDefault();
        this.chance = plugin.config().brushConfig().defaultChance();
        this.thickness = plugin.config().thicknessConfig().defaultThickness();
        this.fractureStrength = plugin.config().fractureConfig().defaultFractureStrength();
        this.angleDistance = plugin.config().angleConfig().defaultAngleDistance();
        this.angleHeightDifference = plugin.config().angleConfig().defaultAngleHeightDifference();
        this.falloffStrength = plugin.config().brushConfig().defaultFalloffStrength();
        this.mixingStrength = plugin.config().brushConfig().defaultMixingStrength();
        this.axis = plugin.config().brushConfig().defaultAxis();
        this.brushSize = plugin.config().brushConfig().defaultSize();
        this.mask = plugin.config().brushConfig().defaultMask();
        this.blocks.addAll(plugin.config().brushConfig().defaultBlocks());
        this.mainMenu = new MainMenu(plugin, this, player);
    }

    @Override
    public Random getRandom() {
        return random;
    }

    @Override
    public void setMask(Material type) {
        this.mask = type;
        this.mainMenu.updateMask();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.mainMenu.updateToggle();
    }

    @Override
    public void addBlock(Material type, int slot) {
        if (this.blocks.size() < slot) {
            this.blocks.add(type);
        } else {
            this.blocks.set(slot - 1, type);
        }
        this.mainMenu.updateBlockPalette();
    }

    @Override
    public void removeBlock(int slot) {
        if (this.blocks.size() < slot) {
            return;
        }
        this.blocks.remove(slot - 1);
        this.mainMenu.updateBlockPalette();
    }

    @Override
    public void setBrush(PatternBrush brush) {
        this.brush = brush;
        this.mainMenu.updateBrush();
    }

    @Override
    public void setBrushSize(@Range(from=1L, to=0x7FFFFFFFL) int size) {
        this.brushSize = Math.clamp((long)size, 1, this.plugin.config().brushConfig().maxBrushSize());
        this.mainMenu.updateSize();
    }

    @Override
    public AbstractGUI getBrushesMenu() {
        return new BrushesMenu(this.plugin, this, this.player);
    }

    @Override
    public void setChance(@Range(from=10L, to=90L) int chance) {
        this.chance = Math.clamp((long)chance, 10, 90);
        this.mainMenu.updateChance();
    }

    @Override
    public void setThickness(@Range(from=1L, to=0x7FFFFFFFL) int thickness) {
        this.thickness = Math.clamp((long)thickness, 1, this.plugin.config().thicknessConfig().maxThickness());
        this.mainMenu.updateThickness();
    }

    @Override
    public void setAngleDistance(@Range(from=1L, to=0x7FFFFFFFL) int distance) {
        this.angleDistance = Math.clamp((long)distance, 1, this.plugin.config().angleConfig().maxAngleDistance());
        this.mainMenu.updateAngleSettings();
    }

    @Override
    public void setFalloffStrength(@Range(from=0L, to=100L) int strength) {
        this.falloffStrength = Math.clamp((long)strength, 0, 100);
        this.mainMenu.updateFalloffStrength();
    }

    @Override
    public void setMixingStrength(@Range(from=0L, to=100L) int strength) {
        this.mixingStrength = Math.clamp((long)strength, 0, 100);
        this.mainMenu.updateMixingStrength();
    }

    @Override
    public void setAngleHeightDifference(double difference) {
        this.angleHeightDifference = Math.clamp(difference, this.plugin.config().angleConfig().minAngleHeightDifference(), this.plugin.config().angleConfig().maxAngleHeightDifference());
        this.mainMenu.updateAngleSettings();
    }

    @Override
    public void setMaskEnabled(boolean maskEnabled) {
        this.maskEnabled = maskEnabled;
        this.mainMenu.updateMaskToggle();
    }

    @Override
    public void setSurfaceMode(SurfaceMode surfaceMode) {
        this.surfaceMode = surfaceMode;
        this.mainMenu.updateSurfaceMode();
    }

    @Override
    public void setAxis(Axis axis) {
        this.axis = axis;
        this.mainMenu.updateAxis();
    }

    @Override
    public void setBlocks(List<Material> blocks) {
        this.blocks.clear();
        this.blocks.addAll(blocks);
        this.mainMenu.updateBlockPalette();
    }

    @Override
    public void setFractureStrength(@Range(from=1L, to=0x7FFFFFFFL) int fractureStrength) {
        this.fractureStrength = Math.clamp((long)fractureStrength, 1, this.plugin.config().fractureConfig().maxFractureStrength());
        this.mainMenu.updateFractureSettings();
    }

    @Override
    public PatternBrush getNextBrush(@Nullable PatternBrush brush) {
        List<PatternBrush> brushes = this.plugin.brushRegistry().getBrushes().toList();
        if (brush == null) {
            return brushes.getFirst();
        }
        int next = brushes.indexOf(brush) + 1;
        if (next < brushes.size()) {
            return brushes.get(next);
        }
        return brushes.getFirst();
    }

    @Override
    public PatternBrush getPreviousBrush(@Nullable PatternBrush brush) {
        List<PatternBrush> brushes = this.plugin.brushRegistry().getBrushes().toList();
        if (brush == null) {
            return brushes.getFirst();
        }
        int back = brushes.indexOf(brush) - 1;
        if (back >= 0) {
            return brushes.get(back);
        }
        return brushes.getLast();
    }

    @Override
    public boolean exportSettings(ItemStack itemStack) {
        if (itemStack.getType().equals((Object)this.plugin.config().brushConfig().defaultBrushType())) {
            return false;
        }
        if (itemStack.getType().isBlock()) {
            return false;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(Component.empty());
        lines.add(this.plugin.bundle().component("brush.exported.size", (Audience)this.player, Formatter.number((String)"size", (Number)this.getBrushSize())));
        if (this.getBrush() instanceof SprayBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.chance", (Audience)this.player, Formatter.number((String)"chance", (Number)this.getChance())));
        } else if (this.getBrush() instanceof OverlayBrush || this.getBrush() instanceof UnderlayBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.thickness", (Audience)this.player, Formatter.number((String)"thickness", (Number)this.getThickness())));
        } else if (this.getBrush() instanceof DiskBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.axis", (Audience)this.player, new TagResolver[]{Placeholder.parsed((String)"axis", (String)this.getAxis().name())}));
        } else if (this.getBrush() instanceof AngleBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.angle.distance", (Audience)this.player, Formatter.number((String)"distance", (Number)this.getAngleDistance())));
            lines.add(this.plugin.bundle().component("brush.exported.angle.height", (Audience)this.player, Formatter.number((String)"height", (Number)this.getAngleHeightDifference())));
        } else if (this.getBrush() instanceof SplatterBrush || this.getBrush() instanceof PaintBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.falloff", (Audience)this.player, Formatter.number((String)"falloff", (Number)this.getFalloffStrength())));
        } else if (this.getBrush() instanceof GradientBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.mixing", (Audience)this.player, Formatter.number((String)"mixing", (Number)this.getMixingStrength())));
            lines.add(this.plugin.bundle().component("brush.exported.falloff", (Audience)this.player, Formatter.number((String)"falloff", (Number)this.getFalloffStrength())));
        } else if (this.getBrush() instanceof FractureBrush) {
            lines.add(this.plugin.bundle().component("brush.exported.fracture", (Audience)this.player, Formatter.number((String)"fracture", (Number)this.getFractureStrength())));
        }
        if (!this.blocks.isEmpty()) {
            List<TranslatableComponent> blocks = this.getBlocks().stream().map(Material::translationKey).map(Component::translatable).toList();
            lines.add(this.plugin.bundle().component("brush.exported.blocks", (Audience)this.player, new TagResolver[]{Placeholder.component((String)"blocks", (ComponentLike)Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), blocks))}));
        }
        if (this.isMaskEnabled()) {
            lines.add(this.plugin.bundle().component("brush.exported.mask", (Audience)this.player, new TagResolver[]{Placeholder.component((String)"mask", (ComponentLike)Component.translatable((String)this.getMask().translationKey()))}));
        }
        if (!this.getSurfaceMode().equals((Object)SurfaceMode.DISABLED)) {
            Component mode = this.plugin.bundle().component(this.getSurfaceMode().translationKey(), (Audience)this.player);
            lines.add(this.plugin.bundle().component("brush.exported.surface-mode", (Audience)this.player, new TagResolver[]{Placeholder.component((String)"mode", (ComponentLike)mode.style(Style.empty()))}));
        }
        itemStack.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        itemStack.setData(DataComponentTypes.ITEM_NAME, (Object)this.plugin.bundle().component("brush.exported.name", (Audience)this.player, new TagResolver[]{Placeholder.component((String)"brush", (ComponentLike)this.getBrush().getName((Audience)this.player))}));
        itemStack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(lines));
        return itemStack.editPersistentDataContainer(container -> {
            container.set(new NamespacedKey("gopaint", "size"), PersistentDataType.INTEGER, (Object)this.getBrushSize());
            container.set(new NamespacedKey("gopaint", "chance"), PersistentDataType.INTEGER, (Object)this.getChance());
            container.set(new NamespacedKey("gopaint", "thickness"), PersistentDataType.INTEGER, (Object)this.getThickness());
            container.set(new NamespacedKey("gopaint", "fracture_strength"), PersistentDataType.INTEGER, (Object)this.getFractureStrength());
            container.set(new NamespacedKey("gopaint", "angle_distance"), PersistentDataType.INTEGER, (Object)this.getAngleDistance());
            container.set(new NamespacedKey("gopaint", "falloff_strength"), PersistentDataType.INTEGER, (Object)this.getFalloffStrength());
            container.set(new NamespacedKey("gopaint", "mixing_strength"), PersistentDataType.INTEGER, (Object)this.getMixingStrength());
            container.set(new NamespacedKey("gopaint", "angle_height_difference"), PersistentDataType.DOUBLE, (Object)this.getAngleHeightDifference());
            container.set(new NamespacedKey("gopaint", "axis"), PersistentDataType.STRING, (Object)this.getAxis().name());
            container.set(new NamespacedKey("gopaint", "mask_enabled"), PersistentDataType.BOOLEAN, (Object)this.isMaskEnabled());
            container.set(new NamespacedKey("gopaint", "surface_mode"), PersistentDataType.STRING, (Object)this.getSurfaceMode().name());
            container.set(new NamespacedKey("gopaint", "brush"), PersistentDataType.STRING, (Object)this.getBrush().key().asString());
            container.set(new NamespacedKey("gopaint", "mask"), PersistentDataType.STRING, (Object)this.getMask().key().asString());
            container.set(new NamespacedKey("gopaint", "blocks"), PersistentDataType.STRING, (Object)this.getBlocks().stream().map(Keyed::key).map(Key::asString).collect(Collectors.joining(",")));
        });
    }

    @Override
    public void importSettings(ItemBrushSettings settings) {
        this.setBrushSize(settings.getBrushSize());
        this.setChance(settings.getBrushSize());
        this.setThickness(settings.getThickness());
        this.setFractureStrength(settings.getFractureStrength());
        this.setAngleDistance(settings.getAngleDistance());
        this.setFalloffStrength(settings.getFalloffStrength());
        this.setMixingStrength(settings.getMixingStrength());
        this.setAngleHeightDifference(settings.getAngleHeightDifference());
        this.setAxis(settings.getAxis());
        this.setMaskEnabled(settings.isMaskEnabled());
        this.setSurfaceMode(settings.getSurfaceMode());
        this.setBrush(settings.getBrush());
        this.setMask(settings.getMask());
        this.setBlocks(settings.getBlocks());
    }

    public GoPaintPlugin getPlugin() {
        return this.plugin;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getBrushSize() {
        return this.brushSize;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public int getThickness() {
        return this.thickness;
    }

    @Override
    public int getFractureStrength() {
        return this.fractureStrength;
    }

    @Override
    public int getAngleDistance() {
        return this.angleDistance;
    }

    @Override
    public int getFalloffStrength() {
        return this.falloffStrength;
    }

    @Override
    public int getMixingStrength() {
        return this.mixingStrength;
    }

    @Override
    public double getAngleHeightDifference() {
        return this.angleHeightDifference;
    }

    @Override
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public boolean isMaskEnabled() {
        return this.maskEnabled;
    }

    @Override
    public SurfaceMode getSurfaceMode() {
        return this.surfaceMode;
    }

    @Override
    public PatternBrush getBrush() {
        return this.brush;
    }

    @Override
    public Material getMask() {
        return this.mask;
    }

    @Override
    public List<Material> getBlocks() {
        return this.blocks;
    }

    @Override
    public MainMenu getMainMenu() {
        return this.mainMenu;
    }
}

