/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush.pattern;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Objects;
import net.thenextlvl.gopaint.api.brush.pattern.BuildPattern;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import org.bukkit.Material;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SplinePattern
implements BuildPattern {
    private final EditSession session;
    private final BlockVector3 position;
    private final Player player;
    private final BrushSettings settings;
    private int random;

    public SplinePattern(EditSession session, BlockVector3 position, Player player, BrushSettings settings) {
        this.session = session;
        this.position = position;
        this.player = player;
        this.settings = settings;
    }

    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        return set.setBlock(extent, this.getRandomBlockState().withProperties(get.getBlock(extent)));
    }

    @Override
    public BlockState getRandomBlockState() {
        int index = Math.clamp((long)this.random(), 0, this.settings().getBlocks().size() - 1);
        BlockType block = BukkitAdapter.asBlockType((Material)this.settings().getBlocks().get(index));
        return Objects.requireNonNull(block).getDefaultState();
    }

    @Override
    public EditSession session() {
        return this.session;
    }

    @Override
    public BlockVector3 position() {
        return this.position;
    }

    @Override
    public Player player() {
        return this.player;
    }

    @Override
    public BrushSettings settings() {
        return this.settings;
    }

    public int random() {
        return this.random;
    }

    public void random(int random) {
        this.random = random;
    }
}

