/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush.pattern;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Objects;
import net.thenextlvl.gopaint.api.brush.pattern.BuildPattern;
import net.thenextlvl.gopaint.api.brush.setting.BrushSettings;
import org.bukkit.Material;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record GradientPattern(EditSession session, BlockVector3 position, Player player, BrushSettings settings) implements BuildPattern
{
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        if (this.settings().getRandom().nextDouble() <= this.getRate(set)) {
            return false;
        }
        return set.setBlock(extent, this.getRandomBlockState(set.y()).withProperties(get.getBlock(extent)));
    }

    public BlockState getRandomBlockState(int altitude) {
        int index = Math.clamp((long)this.getRandom(altitude), 0, this.settings().getBlocks().size() - 1);
        BlockType block = BukkitAdapter.asBlockType((Material)this.settings().getBlocks().get(index));
        return Objects.requireNonNull(block).getDefaultState();
    }

    private int getRandom(int altitude) {
        if (this.settings().getBlocks().size() == 1) {
            return 1;
        }
        double y = (double)this.position().y() - (double)this.settings().getBrushSize() / 2.0;
        double _y = ((double)altitude - y) / (double)this.settings().getBrushSize() * (double)this.settings().getBlocks().size();
        return (int)(_y + (this.settings().getRandom().nextDouble() * 2.0 - 1.0) * ((double)this.settings().getMixingStrength() / 100.0));
    }

    private double getRate(BlockVector3 position) {
        double size = (double)this.settings().getBrushSize() * ((100.0 - (double)this.settings().getFalloffStrength()) / 100.0);
        return (position.distance(this.position()) - size) / ((double)this.settings().getBrushSize() - size);
    }
}

