/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.brush;

import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.thenextlvl.gopaint.GoPaintPlugin;
import net.thenextlvl.gopaint.api.brush.BrushController;
import net.thenextlvl.gopaint.api.brush.PatternBrush;
import net.thenextlvl.gopaint.api.brush.setting.ItemBrushSettings;
import net.thenextlvl.gopaint.api.brush.setting.PlayerBrushSettings;
import net.thenextlvl.gopaint.api.model.SurfaceMode;
import net.thenextlvl.gopaint.brush.settings.CraftItemBrushSettings;
import net.thenextlvl.gopaint.brush.settings.CraftPlayerBrushSettings;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CraftBrushController
implements BrushController {
    private final Map<UUID, PlayerBrushSettings> playerBrushes = new HashMap<UUID, PlayerBrushSettings>();
    private final GoPaintPlugin plugin;

    public CraftBrushController(GoPaintPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public PlayerBrushSettings getBrushSettings(Player player) {
        return this.playerBrushes.computeIfAbsent(player.getUniqueId(), ignored -> new CraftPlayerBrushSettings(this.plugin, player));
    }

    @Override
    public Optional<ItemBrushSettings> parseBrushSettings(ItemStack itemStack) {
        PersistentDataContainerView container = itemStack.getPersistentDataContainer();
        Integer brushSize = (Integer)container.get(new NamespacedKey("gopaint", "size"), PersistentDataType.INTEGER);
        Boolean maskEnabled = (Boolean)container.get(new NamespacedKey("gopaint", "mask_enabled"), PersistentDataType.BOOLEAN);
        SurfaceMode surfaceMode = Optional.ofNullable((String)container.get(new NamespacedKey("gopaint", "surface_mode"), PersistentDataType.STRING)).map(SurfaceMode::valueOf).orElse(null);
        PatternBrush brush = Optional.ofNullable((String)container.get(new NamespacedKey("gopaint", "brush"), PersistentDataType.STRING)).map(Key::key).flatMap(this.plugin.brushRegistry()::getBrush).orElse(null);
        if (brushSize == null || maskEnabled == null || surfaceMode == null || brush == null) {
            return Optional.empty();
        }
        Integer chance = (Integer)container.getOrDefault(new NamespacedKey("gopaint", "chance"), PersistentDataType.INTEGER, (Object)0);
        Integer thickness = (Integer)container.getOrDefault(new NamespacedKey("gopaint", "thickness"), PersistentDataType.INTEGER, (Object)0);
        Integer fractureStrength = (Integer)container.getOrDefault(new NamespacedKey("gopaint", "fracture_strength"), PersistentDataType.INTEGER, (Object)0);
        Integer angleDistance = (Integer)container.getOrDefault(new NamespacedKey("gopaint", "angle_distance"), PersistentDataType.INTEGER, (Object)0);
        Integer falloffStrength = (Integer)container.getOrDefault(new NamespacedKey("gopaint", "falloff_strength"), PersistentDataType.INTEGER, (Object)0);
        Integer mixingStrength = (Integer)container.getOrDefault(new NamespacedKey("gopaint", "mixing_strength"), PersistentDataType.INTEGER, (Object)0);
        Double angleHeightDifference = (Double)container.getOrDefault(new NamespacedKey("gopaint", "angle_height_difference"), PersistentDataType.DOUBLE, (Object)0.0);
        Axis axis = Optional.ofNullable((String)container.get(new NamespacedKey("gopaint", "axis"), PersistentDataType.STRING)).map(Axis::valueOf).orElse(Axis.Y);
        Material mask = Optional.ofNullable((String)container.get(new NamespacedKey("gopaint", "mask"), PersistentDataType.STRING)).map(Material::matchMaterial).orElseThrow();
        List<Material> blocks = Optional.ofNullable((String)container.get(new NamespacedKey("gopaint", "blocks"), PersistentDataType.STRING)).map(string -> string.split(",")).stream().flatMap(Arrays::stream).map(Material::matchMaterial).filter(Objects::nonNull).toList();
        return Optional.of(new CraftItemBrushSettings(brush, mask, blocks, axis, surfaceMode, maskEnabled, brushSize, chance, thickness, angleDistance, fractureStrength, falloffStrength, mixingStrength, angleHeightDifference));
    }

    @Override
    public void removeBrushSettings(Player player) {
        this.playerBrushes.remove(player.getUniqueId());
    }
}

