/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.math.curve;

import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class BezierSplineSegment {
    private final MutableBlockVector3 startPoint;
    private final MutableBlockVector3 endPoint;
    private MutableBlockVector3 intermediatePoint1 = MutableBlockVector3.at((int)0, (int)0, (int)0);
    private MutableBlockVector3 intermediatePoint2 = MutableBlockVector3.at((int)0, (int)0, (int)0);
    private float coefficient1;
    private float coefficient2;
    private float coefficient3;
    private @Nullable Double xFlat;
    private @Nullable Double yFlat;
    private @Nullable Double zFlat;
    private MutableBlockVector3 result = MutableBlockVector3.at((int)0, (int)0, (int)0);

    public BezierSplineSegment(MutableBlockVector3 startPoint, MutableBlockVector3 endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public void setX(double xFlat) {
        this.startPoint.mutX(xFlat);
        this.intermediatePoint1.mutX(xFlat);
        this.intermediatePoint2.mutX(xFlat);
        this.endPoint.mutX(xFlat);
        this.xFlat = xFlat;
    }

    public void setY(double yFlat) {
        this.startPoint.mutY(yFlat);
        this.intermediatePoint1.mutY(yFlat);
        this.intermediatePoint2.mutY(yFlat);
        this.endPoint.mutY(yFlat);
        this.yFlat = yFlat;
    }

    public void setZ(double zFlat) {
        this.startPoint.mutZ(zFlat);
        this.intermediatePoint1.mutZ(zFlat);
        this.intermediatePoint2.mutZ(zFlat);
        this.endPoint.mutZ(zFlat);
        this.zFlat = zFlat;
    }

    @Contract(pure=true)
    public double getCurveLength() {
        MutableBlockVector3 current = this.startPoint;
        double[] lengths = new double[20];
        for (int i = 1; i < lengths.length; ++i) {
            BlockVector3 point = this.getPoint((double)i * 0.05);
            lengths[i] = lengths[i - 1] + point.distance((BlockVector3)current);
            current = point;
        }
        return lengths[lengths.length - 1];
    }

    @Contract(pure=true)
    public BlockVector3 getPoint(double factor) {
        Double x = Objects.requireNonNullElseGet(this.xFlat, () -> this.calculatePoint(factor, this.startPoint.x(), this.intermediatePoint1.x(), this.intermediatePoint2.x(), this.endPoint.x()));
        Double y = Objects.requireNonNullElseGet(this.yFlat, () -> this.calculatePoint(factor, this.startPoint.y(), this.intermediatePoint1.y(), this.intermediatePoint2.y(), this.endPoint.y()));
        Double z = Objects.requireNonNullElseGet(this.zFlat, () -> this.calculatePoint(factor, this.startPoint.z(), this.intermediatePoint1.z(), this.intermediatePoint2.z(), this.endPoint.z()));
        return BlockVector3.at((double)x, (double)y, (double)z);
    }

    @Contract(pure=true)
    private double calculatePoint(double factor, double startPoint, double intermediatePoint1, double intermediatePoint2, double endPoint) {
        return Math.pow(1.0 - factor, 3.0) * startPoint + 3.0 * Math.pow(1.0 - factor, 2.0) * factor * intermediatePoint1 + 3.0 * (1.0 - factor) * factor * factor * intermediatePoint2 + Math.pow(factor, 3.0) * endPoint;
    }

    public MutableBlockVector3 getStartPoint() {
        return this.startPoint;
    }

    public MutableBlockVector3 getEndPoint() {
        return this.endPoint;
    }

    public MutableBlockVector3 getResult() {
        return this.result;
    }

    public MutableBlockVector3 getIntermediatePoint1() {
        return this.intermediatePoint1;
    }

    public MutableBlockVector3 getIntermediatePoint2() {
        return this.intermediatePoint2;
    }

    public float getCoefficient1() {
        return this.coefficient1;
    }

    public float getCoefficient2() {
        return this.coefficient2;
    }

    public float getCoefficient3() {
        return this.coefficient3;
    }

    public @Nullable Double getXFlat() {
        return this.xFlat;
    }

    public @Nullable Double getYFlat() {
        return this.yFlat;
    }

    public @Nullable Double getZFlat() {
        return this.zFlat;
    }

    public void setResult(MutableBlockVector3 result) {
        this.result = result;
    }

    public void setIntermediatePoint1(MutableBlockVector3 intermediatePoint1) {
        this.intermediatePoint1 = intermediatePoint1;
    }

    public void setIntermediatePoint2(MutableBlockVector3 intermediatePoint2) {
        this.intermediatePoint2 = intermediatePoint2;
    }

    public void setCoefficient1(float coefficient1) {
        this.coefficient1 = coefficient1;
    }

    public void setCoefficient2(float coefficient2) {
        this.coefficient2 = coefficient2;
    }

    public void setCoefficient3(float coefficient3) {
        this.coefficient3 = coefficient3;
    }

    public void setXFlat(@Nullable Double xFlat) {
        this.xFlat = xFlat;
    }

    public void setYFlat(@Nullable Double yFlat) {
        this.yFlat = yFlat;
    }

    public void setZFlat(@Nullable Double zFlat) {
        this.zFlat = zFlat;
    }
}

