/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.math;

import com.sk89q.worldedit.math.BlockVector3;
import net.thenextlvl.gopaint.api.model.Block;

public class Height {
    public static int getNearestNonEmptyBlock(Block block) {
        if (block.material().isAir()) {
            for (int y = block.vector().y(); y >= block.world().getMinY(); --y) {
                if (block.world().getBlock(block.vector().x(), y, block.vector().z()).isAir()) continue;
                return y + 1;
            }
            return block.world().getMinY();
        }
        for (int y = block.vector().y(); y <= block.world().getMaxY(); ++y) {
            if (!block.world().getBlock(block.vector().x(), y, block.vector().z()).isAir()) continue;
            return y;
        }
        return block.world().getMaxY();
    }

    public static double getAverageHeightDiffFracture(Block block, int height, int distance) {
        double totalHeight = 0.0;
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, distance, -distance))) - height);
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, distance, distance))) - height);
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, -distance, distance))) - height);
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, -distance, -distance))) - height);
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, 0, -distance))) - height);
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, 0, distance))) - height);
        totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, -distance, 0))) - height);
        return (totalHeight += (double)(Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, distance, 0))) - height)) / 8.0 / (double)distance;
    }

    private static Block relative(Block block, int x, int z) {
        BlockVector3 vector3 = block.vector().add(x, 0, z);
        return new Block(block.world().getFullBlock(vector3), vector3, block.world());
    }

    public static double getAverageHeightDiffAngle(Block block, int distance) {
        int maxHeightDiff = 0;
        int maxHeightDiff2 = 0;
        int diff = Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, distance, -distance)) - Height.getNearestNonEmptyBlock(Height.relative(block, -distance, distance)));
        if (diff >= maxHeightDiff) {
            maxHeightDiff2 = maxHeightDiff = diff;
        }
        if ((diff = Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, distance, distance)) - Height.getNearestNonEmptyBlock(Height.relative(block, -distance, -distance)))) > maxHeightDiff) {
            maxHeightDiff2 = maxHeightDiff = diff;
        }
        if ((diff = Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, distance, 0)) - Height.getNearestNonEmptyBlock(Height.relative(block, -distance, 0)))) > maxHeightDiff) {
            maxHeightDiff2 = maxHeightDiff = diff;
        }
        if ((diff = Math.abs(Height.getNearestNonEmptyBlock(Height.relative(block, 0, -distance)) - Height.getNearestNonEmptyBlock(Height.relative(block, 0, distance)))) > maxHeightDiff) {
            maxHeightDiff2 = maxHeightDiff = diff;
        }
        return (double)(maxHeightDiff2 + maxHeightDiff) / ((double)distance * 2.0);
    }
}

