/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.gopaint.api.math;

import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.block.BlockFace;

public class ConnectedBlocks {
    private static final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    public static Stream<BlockVector3> getConnectedBlocks(Extent world, BlockVector3 vector3, Set<BlockVector3> blocks) {
        BaseBlock startBlock = world.getFullBlock(vector3);
        HashSet<Object> connected = new HashSet<Object>();
        LinkedList<Object> toCheck = new LinkedList<Object>();
        toCheck.add(vector3);
        connected.add(vector3);
        while (!toCheck.isEmpty() && connected.size() < blocks.size()) {
            BlockVector3 current = (BlockVector3)toCheck.poll();
            Set neighbors = Arrays.stream(faces).map(face -> current.add(face.getModX(), face.getModY(), face.getModZ())).filter(relative -> !connected.contains(relative)).filter(blocks::contains).filter(relative -> world.getBlock(relative).getMaterial().equals((Object)startBlock.getMaterial())).collect(Collectors.toSet());
            connected.addAll(neighbors);
            toCheck.addAll(neighbors);
        }
        return connected.stream();
    }
}

