/*
 * Decompiled with CFR 0.152.
 */
package core.file.formats;

import core.file.FileIO;
import core.file.Validatable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.BiConsumer;

public class PropertiesFile
extends FileIO<Properties>
implements Validatable<Properties> {
    protected final Properties defaultRoot;

    public PropertiesFile(Path file, Charset charset, Properties root) {
        super(file, charset, root);
        this.defaultRoot = root;
    }

    public PropertiesFile(Path file, Charset charset) {
        this(file, charset, new Properties());
    }

    public PropertiesFile(Path file, Properties root) {
        this(file, StandardCharsets.UTF_8, root);
    }

    public PropertiesFile(Path file) {
        this(file, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Properties load() {
        if (!Files.isRegularFile(this.getFile(), new LinkOption[0])) {
            return (Properties)((Properties)this.getRoot()).clone();
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.getFile(), StandardOpenOption.READ), this.getCharset());){
            Properties properties;
            try (BufferedReader buffer = new BufferedReader(reader);){
                Properties properties2 = new Properties();
                properties2.load(buffer);
                properties = properties2;
            }
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FileIO<Properties> save(FileAttribute<?> ... attributes) {
        PropertiesFile propertiesFile;
        Properties root = (Properties)this.getRoot();
        Files.createDirectories(this.getFile().toAbsolutePath().getParent(), new FileAttribute[0]);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.getFile(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.getCharset()));
        try {
            root.store(writer, null);
            propertiesFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return propertiesFile;
    }

    public PropertiesFile validate(Validatable.Scope scope) {
        Properties root = (Properties)this.getRoot();
        if (root == this.defaultRoot) {
            return this;
        }
        if (scope.isFiltering()) {
            root.entrySet().removeIf(entry -> !this.defaultRoot.containsKey(entry.getKey()));
        }
        if (scope.isFilling()) {
            this.merge(this.defaultRoot);
        }
        return this;
    }

    public PropertiesFile merge(Properties properties) {
        Properties root = (Properties)this.getRoot();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (root.containsKey(key)) {
                return;
            }
            root.put(key, value);
        }));
        return this;
    }
}

