/*
 * Decompiled with CFR 0.152.
 */
package core.file;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class FileIO<R> {
    private final Path file;
    private final Charset charset;
    private R root;
    private boolean loaded;

    protected FileIO(Path file, Charset charset, R root) {
        this.file = file;
        this.charset = charset;
        this.root = root;
    }

    protected FileIO(Path file, R root) {
        this(file, StandardCharsets.UTF_8, root);
    }

    public final FileIO<R> setRoot(R root) {
        this.loaded = true;
        this.root = root;
        return this;
    }

    public R getRoot() {
        if (this.loaded) {
            return this.root;
        }
        this.loaded = true;
        this.root = this.load();
        return this.root;
    }

    protected abstract R load();

    public abstract FileIO<R> save(FileAttribute<?> ... var1);

    public FileIO<R> reload() {
        return this.setRoot(this.load());
    }

    public FileIO<R> saveIfAbsent() {
        return Files.isRegularFile(this.file, new LinkOption[0]) ? this : this.save(new FileAttribute[0]);
    }

    public boolean delete() throws IOException {
        return Files.deleteIfExists(this.file);
    }

    public Path getFile() {
        return this.file;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

