/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds;

import core.i18n.file.ComponentBundle;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.worlds.api.WorldsProvider;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.view.GeneratorView;
import net.thenextlvl.worlds.bstats.bukkit.Metrics;
import net.thenextlvl.worlds.command.SaveAllCommand;
import net.thenextlvl.worlds.command.SaveOffCommand;
import net.thenextlvl.worlds.command.SaveOnCommand;
import net.thenextlvl.worlds.command.SeedCommand;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.WorldSetSpawnCommand;
import net.thenextlvl.worlds.level.LevelData;
import net.thenextlvl.worlds.link.WorldLinkProvider;
import net.thenextlvl.worlds.listener.FoliaPortalListener;
import net.thenextlvl.worlds.listener.PortalListener;
import net.thenextlvl.worlds.listener.TeleportListener;
import net.thenextlvl.worlds.listener.WorldListener;
import net.thenextlvl.worlds.model.MessageMigrator;
import net.thenextlvl.worlds.version.PluginVersionChecker;
import net.thenextlvl.worlds.view.FoliaLevelView;
import net.thenextlvl.worlds.view.PaperLevelView;
import net.thenextlvl.worlds.view.PluginGeneratorView;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldsPlugin
extends JavaPlugin
implements WorldsProvider {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/worlds/issues/new?template=bug_report.yml";
    public static final boolean RUNNING_FOLIA = ServerBuildInfo.buildInfo().isBrandCompatible(Key.key((String)"papermc", (String)"folia"));
    private final GeneratorView generatorView = new PluginGeneratorView();
    private final PaperLevelView levelView = RUNNING_FOLIA ? new FoliaLevelView(this) : new PaperLevelView(this);
    private final WorldLinkProvider linkProvider = new WorldLinkProvider(this);
    private final Path presetsFolder = this.getDataPath().resolve("presets");
    private final Path translations = this.getDataPath().resolve("translations");
    private final Key key = Key.key((String)"worlds", (String)"translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).migrator(new MessageMigrator()).placeholder("prefix", "prefix").resource("worlds.properties", Locale.US).resource("worlds_german.properties", Locale.GERMANY).build();
    private final PluginVersionChecker versionChecker = new PluginVersionChecker(this);
    private final Metrics metrics = new Metrics(this, 19652);

    public WorldsPlugin() {
        this.registerCommands();
    }

    public void onLoad() {
        this.createPresetsFolder();
        if (RUNNING_FOLIA) {
            this.warnExperimental();
        } else {
            this.checkPerWorldsRemnants();
        }
        this.versionChecker.checkVersion();
        this.registerServices();
    }

    private void checkPerWorldsRemnants() {
        if (this.getServer().getPluginManager().getPlugin("PerWorlds") != null) {
            return;
        }
        try (Stream<Path> files = Files.list(Path.of("plugins", "PerWorlds", "groups"));){
            if (files.noneMatch(path -> switch (path.getFileName().toString()) {
                case "unowned", "unowned.dat", "unowned.dat_old" -> false;
                default -> true;
            })) {
                return;
            }
            this.getComponentLogger().warn("It looks like you have been using world groups before.");
            this.getComponentLogger().warn("World groups were provided by PerWorlds which is no longer inbuilt!");
            this.getComponentLogger().warn("If you want to continue using it you can download it from https://modrinth.com/project/lpfQmSV2");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onDisable() {
        this.linkProvider.persistTrees();
    }

    public void onEnable() {
        this.warnVoidGeneratorPlugin();
        this.registerListeners();
    }

    private void warnVoidGeneratorPlugin() {
        Stream<String> names = Stream.of("VoidWorldGenerator", "VoidGen", "VoidGenerator", "VoidWorld", "VoidGenPlus", "DeluxeVoidWorld");
        if (names.map(arg_0 -> ((PluginManager)this.getServer().getPluginManager()).getPlugin(arg_0)).filter(Objects::nonNull).findAny().isEmpty()) {
            return;
        }
        this.getComponentLogger().warn("It appears you are using a plugin to generate void worlds");
        this.getComponentLogger().warn("This is not required, and incompatible with Vanilla world generation");
        this.getComponentLogger().warn("Please use the preset 'the-void' instead");
        this.getComponentLogger().warn("You can do this with the command '/world create <key> preset the-void'");
    }

    public Path presetsFolder() {
        return this.presetsFolder;
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    @Override
    public GeneratorView generatorView() {
        return this.generatorView;
    }

    @Override
    public Level.Builder levelBuilder(Path directory) {
        return new LevelData.Builder(this, directory);
    }

    @Override
    public Level.Builder levelBuilder(World world) {
        Level.Builder builder = this.levelView().read(world.getWorldFolder().toPath()).orElseGet(() -> this.levelBuilder(world.getWorldFolder().toPath())).bonusChest(world.hasBonusChest()).hardcore(world.isHardcore()).structures(world.canGenerateStructures()).worldKnown(true).seed(world.getSeed()).biomeProvider(world.getBiomeProvider()).chunkGenerator(world.getGenerator()).key(world.key());
        return builder.levelStem(switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> LevelStem.OVERWORLD;
            case World.Environment.NETHER -> LevelStem.NETHER;
            case World.Environment.THE_END -> LevelStem.END;
            default -> null;
        }).seed(world.getSeed()).name(world.getName());
    }

    public <T> CompletableFuture<T> supplyGlobal(Supplier<CompletableFuture<T>> supplier) {
        if (this.getServer().isGlobalTickThread()) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        CompletableFuture future = new CompletableFuture();
        this.getServer().getGlobalRegionScheduler().execute((Plugin)this, () -> ((CompletableFuture)((CompletableFuture)supplier.get()).thenAccept(future::complete)).exceptionally(e -> {
            future.completeExceptionally((Throwable)e);
            return null;
        }));
        return future;
    }

    @Override
    public PaperLevelView levelView() {
        return this.levelView;
    }

    @Override
    public WorldLinkProvider linkProvider() {
        return this.linkProvider;
    }

    private void createPresetsFolder() {
        try {
            Files.createDirectories(this.presetsFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.getComponentLogger().warn("Failed to create presets folder", (Throwable)e);
        }
    }

    private void warnExperimental() {
        this.getComponentLogger().warn("Folia builds of Worlds are extremely experimental");
        this.getComponentLogger().warn("Please report any issues you encounter to {}", (Object)ISSUES);
    }

    private void registerServices() {
        this.getServer().getServicesManager().register(WorldsProvider.class, (Object)this, (Plugin)this, ServicePriority.Highest);
    }

    private void registerListeners() {
        PortalListener portalListener = RUNNING_FOLIA ? new FoliaPortalListener(this) : new PortalListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)new TeleportListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)portalListener, (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> {
            ((Commands)event.registrar()).register(SaveAllCommand.create(this), "Save all worlds");
            ((Commands)event.registrar()).register(SaveOffCommand.create(this), "Disable automatic world saving");
            ((Commands)event.registrar()).register(SaveOnCommand.create(this), "Enable automatic world saving");
            ((Commands)event.registrar()).register(SeedCommand.create(this), "Query the seed of a world");
            ((Commands)event.registrar()).register(WorldCommand.create(this), "The main command to interact with this plugin");
            ((Commands)event.registrar()).register(WorldSetSpawnCommand.create(this, "setworldspawn"), "Set the world spawn");
        }));
    }
}

