/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command.link;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.WorldArgument;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import net.thenextlvl.worlds.command.suggestion.LinkSuggestionProvider;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldLinkCreateCommand
extends SimpleCommand {
    private WorldLinkCreateCommand(WorldsPlugin plugin) {
        super(plugin, "create", "worlds.command.link.create");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldLinkCreateCommand command = new WorldLinkCreateCommand(plugin);
        return command.create().then(command.createArgument());
    }

    private RequiredArgumentBuilder<CommandSourceStack, World> createArgument() {
        return (RequiredArgumentBuilder)WorldCommand.worldArgument(this.plugin).suggests(new LinkSuggestionProvider(this.plugin, false)).then(Commands.argument((String)"destination", (ArgumentType)new WorldArgument(this.plugin)).suggests(new LinkSuggestionProvider.Unlinked(this.plugin)).executes((Command)this));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        World world = (World)context.getArgument("world", World.class);
        World destination = (World)context.getArgument("destination", World.class);
        boolean link = this.plugin.linkProvider().link(world, destination);
        String message = link ? "world.link.success" : "world.link.failed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.parsed((String)"source", (String)world.key().asString()), Placeholder.parsed((String)"destination", (String)destination.key().asString())});
        return link ? 1 : 0;
    }
}

