/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.brigadier.BrigadierCommand;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldSaveCommand
extends BrigadierCommand {
    private WorldSaveCommand(WorldsPlugin plugin) {
        super(plugin, "save", "worlds.command.save");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldSaveCommand command = new WorldSaveCommand(plugin);
        return command.create().then(((RequiredArgumentBuilder)WorldCommand.worldArgument(plugin).then(Commands.literal((String)"flush").executes(command::flush))).executes(command::save));
    }

    public int flush(CommandContext<CommandSourceStack> context) {
        return this.save(context, true);
    }

    private int save(CommandContext<CommandSourceStack> context) {
        return this.save(context, false);
    }

    private int save(CommandContext<CommandSourceStack> context, boolean flush) {
        World world = (World)context.getArgument("world", World.class);
        TagResolver.Single placeholder = Placeholder.parsed((String)"world", (String)world.getName());
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.save", new TagResolver[]{placeholder});
        ((CompletableFuture)this.plugin.levelView().saveAsync(world, flush).thenAccept(ignored -> this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.save.success", new TagResolver[]{placeholder}))).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.save.failed", new TagResolver[]{placeholder});
            this.plugin.getComponentLogger().warn("Failed to save world {}", (Object)world.getName(), throwable);
            return null;
        });
        return 1;
    }
}

