/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.GeneratorType;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.preset.Preset;
import net.thenextlvl.worlds.command.WorldCommand;
import net.thenextlvl.worlds.command.argument.KeyArgument;
import net.thenextlvl.worlds.command.argument.LevelStemArgument;
import net.thenextlvl.worlds.command.argument.SeedArgument;
import net.thenextlvl.worlds.command.brigadier.OptionCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldRecreateCommand
extends OptionCommand {
    private WorldRecreateCommand(WorldsPlugin plugin) {
        super(plugin, "recreate", "worlds.command.recreate");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldRecreateCommand command = new WorldRecreateCommand(plugin);
        return command.create().then(command.createCommand());
    }

    @Override
    protected RequiredArgumentBuilder<CommandSourceStack, ?> createCommand() {
        RequiredArgumentBuilder name = Commands.argument((String)"name", (ArgumentType)StringArgumentType.string());
        this.addOptions((ArgumentBuilder<CommandSourceStack, ?>)name, false, Set.of(new OptionCommand.Option("bonus-chest", (ArgumentType<?>)BoolArgumentType.bool()), new OptionCommand.Option("hardcore", (ArgumentType<?>)BoolArgumentType.bool()), new OptionCommand.Option("dimension", (ArgumentType<?>)new LevelStemArgument(this.plugin)), new OptionCommand.Option("key", (ArgumentType<?>)new KeyArgument()), new OptionCommand.Option("seed", (ArgumentType<?>)new SeedArgument()), new OptionCommand.Option("structures", (ArgumentType<?>)BoolArgumentType.bool())), null);
        return (RequiredArgumentBuilder)WorldCommand.worldArgument(this.plugin).then(name.executes((Command)this));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        World world = (World)context.getArgument("world", World.class);
        String name = (String)context.getArgument("name", String.class);
        Level.Builder builder = this.plugin.levelBuilder(world).directory(this.plugin.levelView().findFreePath(name));
        this.tryGetArgument(context, "bonus-chest", Boolean.class).ifPresent(builder::bonusChest);
        this.tryGetArgument(context, "dimension", LevelStem.class).ifPresent(builder::levelStem);
        this.tryGetArgument(context, "generator", Generator.class).ifPresent(builder::generator);
        this.tryGetArgument(context, "hardcore", Boolean.class).ifPresent(builder::hardcore);
        this.tryGetArgument(context, "key", Key.class).ifPresentOrElse(builder::key, () -> builder.key(this.plugin.levelView().findFreeKey(world.key())));
        this.tryGetArgument(context, "preset", Preset.class).ifPresent(builder::preset);
        this.tryGetArgument(context, "seed", Long.class).ifPresent(builder::seed);
        this.tryGetArgument(context, "structures", Boolean.class).ifPresent(builder::structures);
        this.tryGetArgument(context, "type", GeneratorType.class).ifPresent(builder::generatorType);
        Level level = builder.name(name).build();
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        TagResolver.Single placeholder = Placeholder.parsed((String)"world", (String)world.getName());
        this.plugin.bundle().sendMessage((Audience)sender, "world.recreate", new TagResolver[]{placeholder});
        ((CompletableFuture)level.createAsync().thenAccept(recreated -> {
            this.plugin.bundle().sendMessage((Audience)sender, "world.recreate.success", new TagResolver[]{placeholder});
            if (!(sender instanceof Entity)) {
                return;
            }
            Entity entity = (Entity)sender;
            entity.teleportAsync(recreated.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to recreate world {}", (Object)world.getName(), throwable);
            this.plugin.bundle().sendMessage((Audience)sender, "world.recreate.failed", new TagResolver[]{placeholder});
            return null;
        });
        return 1;
    }
}

