/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.command.argument.LevelPathArgument;
import net.thenextlvl.worlds.command.brigadier.SimpleCommand;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class WorldLoadCommand
extends SimpleCommand {
    private WorldLoadCommand(WorldsPlugin plugin) {
        super(plugin, "load", "worlds.command.load");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldLoadCommand command = new WorldLoadCommand(plugin);
        return command.create().then(command.load());
    }

    private RequiredArgumentBuilder<CommandSourceStack, Path> load() {
        return (RequiredArgumentBuilder)Commands.argument((String)"path", (ArgumentType)new LevelPathArgument(this.plugin, false)).executes((Command)this);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Path path = (Path)context.getArgument("path", Path.class);
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.load", new TagResolver[]{Placeholder.parsed((String)"world", (String)path.toString())});
        Optional<Level> build = this.plugin.levelView().read(path).map(Level.Builder::build);
        CompletableFuture future = build.filter(Level::isWorldKnown).map(Level::createAsync).orElse(null);
        if (future == null) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.load.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)path.toString())});
            return 0;
        }
        ((CompletableFuture)future.thenAccept(level -> {
            this.plugin.levelView().setEnabled((World)level, true);
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.load.success", new TagResolver[]{Placeholder.parsed((String)"world", (String)level.getName())});
            CommandSender patt0$temp = ((CommandSourceStack)context.getSource()).getSender();
            if (!(patt0$temp instanceof Entity)) {
                return;
            }
            Entity entity = (Entity)patt0$temp;
            entity.teleportAsync(level.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to load world {}", (Object)path, throwable);
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "world.load.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)path.toString())});
            return null;
        });
        return 1;
    }
}

