/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.worlds.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.worlds.WorldsPlugin;
import net.thenextlvl.worlds.api.generator.Generator;
import net.thenextlvl.worlds.api.generator.GeneratorType;
import net.thenextlvl.worlds.api.generator.LevelStem;
import net.thenextlvl.worlds.api.level.Level;
import net.thenextlvl.worlds.api.preset.Preset;
import net.thenextlvl.worlds.command.argument.GeneratorArgument;
import net.thenextlvl.worlds.command.argument.GeneratorTypeArgument;
import net.thenextlvl.worlds.command.argument.KeyArgument;
import net.thenextlvl.worlds.command.argument.LevelStemArgument;
import net.thenextlvl.worlds.command.argument.SeedArgument;
import net.thenextlvl.worlds.command.argument.WorldPresetArgument;
import net.thenextlvl.worlds.command.brigadier.OptionCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class WorldCreateCommand
extends OptionCommand {
    private WorldCreateCommand(WorldsPlugin plugin) {
        super(plugin, "create", "worlds.command.create");
    }

    public static ArgumentBuilder<CommandSourceStack, ?> create(WorldsPlugin plugin) {
        WorldCreateCommand command = new WorldCreateCommand(plugin);
        return command.create().then(command.createCommand());
    }

    @Override
    protected RequiredArgumentBuilder<CommandSourceStack, ?> createCommand() {
        RequiredArgumentBuilder name = Commands.argument((String)"name", (ArgumentType)StringArgumentType.string());
        this.addOptions((ArgumentBuilder<CommandSourceStack, ?>)name, true, Set.of(new OptionCommand.Option("generator", (ArgumentType<?>)new GeneratorArgument(this.plugin)), new OptionCommand.Option("preset", (ArgumentType<?>)new WorldPresetArgument(this.plugin)), new OptionCommand.Option("type", (ArgumentType<?>)new GeneratorTypeArgument(this.plugin))), builder -> this.addOptions((ArgumentBuilder<CommandSourceStack, ?>)builder, false, Set.of(new OptionCommand.Option("bonus-chest", (ArgumentType<?>)BoolArgumentType.bool()), new OptionCommand.Option("hardcore", (ArgumentType<?>)BoolArgumentType.bool()), new OptionCommand.Option("dimension", (ArgumentType<?>)new LevelStemArgument(this.plugin)), new OptionCommand.Option("key", (ArgumentType<?>)new KeyArgument()), new OptionCommand.Option("seed", (ArgumentType<?>)new SeedArgument()), new OptionCommand.Option("structures", (ArgumentType<?>)BoolArgumentType.bool())), null));
        return (RequiredArgumentBuilder)name.executes((Command)this);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Level level = this.buildLevel(context, sender);
        if (level == null) {
            return 0;
        }
        TagResolver.Single placeholder = Placeholder.parsed((String)"world", (String)level.getName());
        if (this.plugin.getServer().getWorld(level.getName()) != null) {
            this.plugin.bundle().sendMessage((Audience)sender, "world.name.taken", new TagResolver[]{placeholder});
            return 0;
        }
        if (this.plugin.getServer().getWorld(level.key()) != null) {
            this.plugin.bundle().sendMessage((Audience)sender, "world.key.taken", new TagResolver[]{Placeholder.parsed((String)"key", (String)level.key().asString())});
            return 0;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "world.create", new TagResolver[]{placeholder});
        ((CompletableFuture)level.createAsync().thenAccept(world -> {
            this.plugin.bundle().sendMessage((Audience)sender, "world.create.success", new TagResolver[]{placeholder});
            if (!(sender instanceof Entity)) {
                return;
            }
            Entity entity = (Entity)sender;
            entity.teleportAsync(world.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        })).exceptionally(throwable -> {
            this.plugin.getComponentLogger().warn("Failed to create world {} ({})", new Object[]{level.key(), level.getName(), throwable});
            this.plugin.bundle().sendMessage((Audience)sender, "world.create.failed", new TagResolver[]{placeholder});
            return null;
        });
        return 1;
    }

    private @Nullable Level buildLevel(CommandContext<CommandSourceStack> context, CommandSender sender) {
        String name = (String)context.getArgument("name", String.class);
        try {
            return this.plugin.levelBuilder(this.plugin.levelView().findFreePath(name)).levelStem(this.tryGetArgument(context, "dimension", LevelStem.class).orElse(null)).generator(this.tryGetArgument(context, "generator", Generator.class).orElse(null)).key(this.tryGetArgument(context, "key", Key.class).orElse(null)).preset(this.tryGetArgument(context, "preset", Preset.class).orElse(null)).seed(this.tryGetArgument(context, "seed", Long.class).orElse(null)).structures(this.tryGetArgument(context, "structures", Boolean.class).orElse(null)).generatorType(this.tryGetArgument(context, "type", GeneratorType.class).orElse(null)).bonusChest(this.tryGetArgument(context, "bonus-chest", Boolean.class).orElse(null)).hardcore(this.tryGetArgument(context, "hardcore", Boolean.class).orElse(null)).name(name).build();
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().warn("Failed to create world {}", (Object)name, (Object)e);
            this.plugin.bundle().sendMessage((Audience)sender, "world.create.failed", new TagResolver[]{Placeholder.parsed((String)"world", (String)name)});
            return null;
        }
    }
}

