/*
 * Decompiled with CFR 0.152.
 */
package core.paper.cache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerCache {
    private static final Path playerData = Objects.requireNonNull(Bukkit.getWorld((Key)Key.key((String)"minecraft", (String)"overworld"))).getWorldPath().resolve("playerdata");

    public static Stream<OfflinePlayer> getOfflinePlayers() {
        return PlayerCache.getStoredPlayers().map(Bukkit::getOfflinePlayer);
    }

    public static Stream<UUID> getStoredPlayers() {
        try {
            Stream<Path> files = Files.list(playerData);
            return (Stream)files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(name -> name.endsWith(".dat")).map(name -> name.substring(0, name.length() - 4)).map(s -> {
                try {
                    return UUID.fromString(s);
                }
                catch (IllegalArgumentException ignored) {
                    return null;
                }
            }).filter(Objects::nonNull).onClose(files::close);
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }
}

