/*
 * Decompiled with CFR 0.152.
 */
package core.version.github;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import core.version.Version;
import core.version.VersionChecker;
import core.version.github.Release;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class GitHubVersionChecker<V extends Version>
implements VersionChecker<Release, V> {
    private static final String API_URL = "https://api.github.com/repos/%s/%s/";
    private static final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private static final Gson gson = new Gson();
    private Set<Release> releases = new HashSet<Release>();
    private final String owner;
    private final String repository;

    public GitHubVersionChecker(String owner, String repository) {
        this.owner = owner;
        this.repository = repository;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepository() {
        return this.repository;
    }

    @Override
    public CompletableFuture<V> retrieveLatestVersion() {
        return ((CompletableFuture)this.get("releases/latest").thenApply(response -> {
            Release release = (Release)gson.fromJson((String)response.body(), Release.class);
            this.releases.add(release);
            return release;
        })).thenApply(release -> this.parseVersion(release.tag()));
    }

    @Override
    public CompletableFuture<Set<V>> retrieveVersions() {
        return this.retrieveGitHubReleases().thenApply(versions -> versions.stream().map(this::parseVersion).collect(Collectors.toUnmodifiableSet()));
    }

    @Override
    public CompletableFuture<Optional<V>> retrieveLatestSupportedVersion() {
        return this.retrieveGitHubReleases().thenApply(versions -> versions.stream().filter(this::isSupported).map(this::parseVersion).max(Comparable::compareTo));
    }

    @Override
    public Set<V> getSupportedVersions() {
        return this.releases.stream().filter(this::isSupported).map(this::parseVersion).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<V> getVersions() {
        return this.releases.stream().map(this::parseVersion).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<V> getLatestSupportedVersion() {
        return this.releases.stream().filter(this::isSupported).map(this::parseVersion).max(Comparable::compareTo);
    }

    @Override
    public Optional<V> getLatestVersion() {
        return this.releases.stream().map(this::parseVersion).max(Comparable::compareTo);
    }

    @Override
    public V parseVersion(Release version) {
        return this.parseVersion(version.tag());
    }

    public final CompletableFuture<Set<Release>> retrieveGitHubReleases() {
        return this.get("releases").thenApply(response -> {
            this.releases = (Set)gson.fromJson((String)response.body(), (TypeToken)new TypeToken<HashSet<Release>>(this){});
            return this.releases;
        });
    }

    private CompletableFuture<HttpResponse<String>> get(String path) {
        return client.sendAsync(HttpRequest.newBuilder().uri(URI.create(API_URL.formatted(this.getOwner(), this.getRepository()) + path)).header("Accept", "application/vnd.github+json").build(), HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Server responded with status code %s, are owner and repository correct (%s, %s)?\n%s".formatted(response.statusCode(), this.getOwner(), this.getRepository(), response.body()));
            }
            return response;
        });
    }
}

